/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.clarent.Clarent;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ClarentEffect {
    public static void clarentOnRightClick(Player player) {
        List list;
        ItemStack s = player.getMainHandItem();
        if (player.level() != null && !player.level().isClientSide && s.getItem() instanceof SwordItem && StrengtheningSpellEffect.getStrengthened(s) > 0 && !ClarentEffect.blacklisted(s, player.level()) && !(list = player.level().getEntitiesOfClass(AreaEffectCloud.class, player.getBoundingBox().inflate(2.0), e -> e != null && e.isAlive() && e.getOwner() instanceof EnderDragon)).isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = (AreaEffectCloud)list.get(0);
            areaeffectcloudentity.setRadius(areaeffectcloudentity.getRadius() - 0.5f);
            ItemStack clarent = new ItemStack((ItemLike)ModItems.clarent.get());
            SwordMahou mahou = Utils.getSwordMahou(clarent);
            mahou.setAttackDamage(0.0f);
            Utils.setSwordMahou(clarent, mahou);
            if (MTConfig.CLARENT_UNBREAKABLE) {
                clarent.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            }
            ClarentEffect.turnSwordIntoItem(player, clarent);
            ((MahouTrigger)((Object)ModTriggers.CLARENT.get())).trigger((ServerPlayer)player);
        }
    }

    public static void turnSwordIntoItem(Player player, ItemStack change) {
        player.getInventory().removeItemNoUpdate(player.getInventory().selected);
        if (!player.getInventory().add(player.getInventory().selected, change)) {
            player.drop(change, false);
        }
    }

    public static void clarentLivingHurt(LivingIncomingDamageEvent event) {
        Player player;
        Entity e = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (e instanceof Player && !e.level().isClientSide && target != null && event.getAmount() > 0.0f && (player = (Player)e).getMainHandItem().getItem() instanceof Clarent) {
            float d1 = Clarent.calculateDamageFromWeapon(target.getMainHandItem());
            float d2 = Clarent.calculateDamageFromWeapon(target.getOffhandItem());
            d1 = Math.max(d1, d2);
            SwordMahou mahou = Utils.getSwordMahou(player.getMainHandItem());
            if (mahou != null) {
                int mana = ClarentEffect.getManaCostClarent(player.getMainHandItem(), player);
                if (mana <= 0) {
                    d1 += mahou.getAttackDamage();
                } else if (PlayerManaManager.drainMana(player, mana, false, false) == mana) {
                    d1 = (float)((double)d1 + ClarentEffect.getDamageFromManaClarent(mana));
                }
                mahou.setAttackDamage(0.0f);
            }
            Utils.setSwordMahou(player.getMainHandItem(), mahou);
            event.setAmount(d1);
            EffectUtil.buff(target, ModEffects.WOUNDED, false, MTConfig.CLARENT_WOUND_TICKS);
            if (target instanceof ServerPlayer) {
                ((ServerPlayer)target).displayClientMessage((Component)Component.translatable((String)"mahoutsukai.clarent.wounded"), true);
            }
        }
    }

    public static int getManaCostClarent(ItemStack stack, Player player) {
        SwordMahou mahou = Utils.getSwordMahou(stack);
        int mana = 0;
        mana = (int)(MTConfig.CLARENT_MANA_PER_DAMAGE * (double)mahou.getAttackDamage());
        mana = Math.min(mana, PlayerManaManager.countMana(player));
        return mana;
    }

    public static double getDamageFromManaClarent(int mana) {
        return (double)mana / MTConfig.CLARENT_MANA_PER_DAMAGE;
    }

    public static void clarentLivingAttack(LivingIncomingDamageEvent event) {
        Entity e;
        LivingEntity target = event.getEntity();
        if (!target.level().isClientSide && target.isBlocking() && target.getUseItem().getItem() instanceof Clarent) {
            target.getUseItem().hurtAndBreak(1, target, EquipmentSlot.MAINHAND);
            SwordMahou mahou = Utils.getSwordMahou(target.getUseItem());
            mahou.setAttackDamage(Math.min((float)MTConfig.CLARENT_ATTACK_CAP, mahou.getAttackDamage() + event.getAmount() * (float)MTConfig.CLARENT_STORED_FACTOR));
            Utils.setSwordMahou(target.getUseItem(), mahou);
        }
        if ((e = event.getSource().getEntity()) instanceof LivingEntity && ((LivingEntity)e).getMainHandItem().getItem() == ModItems.clarent.get() && target.isBlocking()) {
            SwordMahou mahou = Utils.getSwordMahou(((LivingEntity)e).getMainHandItem());
            mahou.setAttackDamage(0.0f);
            Utils.setSwordMahou(((LivingEntity)e).getMainHandItem(), mahou);
        }
    }

    public static boolean blacklisted(ItemStack s, Level level) {
        List<? extends String> blacklist = MTConfig.CLARENT_SWORD_BLACKLIST;
        boolean bl = MTConfig.CLARENT_BLACKLIST_TOGGLE;
        boolean in = EffectUtil.inItemBlacklist(s.getItem(), blacklist, level);
        return in && bl;
    }
}

