/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.displacement;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.DoneMentalPacket;
import stepsword.mahoutsukai.util.Utils;

public class MentalDisplacementSpellEffect {
    public static boolean leaveBody(Player player) {
        MentalDisplacementEntity entity = new MentalDisplacementEntity(player.level(), Utils.toBlockPos(new Vec3(player.getX(), player.getY(), player.getZ())), player);
        entity.setOwnerId(player.getUUID());
        player.level().addFreshEntity((Entity)entity);
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            mahou.setMentalDisplacementPos(Utils.toBlockPos(new Vec3(player.getX(), player.getY(), player.getZ())));
            if (player instanceof ServerPlayer) {
                PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
            }
        }
        return true;
    }

    public static boolean mentalDisplacementServer(Player player) {
        boolean ret = false;
        if (player != null) {
            ret = true;
            DoneMentalPacket.onMessage(null, player);
        }
        return ret;
    }

    public static void mentalDisplacementLivingUpdate(Entity e) {
        IMahou mahou;
        if (e instanceof Player && (mahou = Utils.getPlayerMahou((Player)e)) != null && mahou.getMentalDisplacementPos() != null && MentalDisplacementSpellEffect.checkDistance(Utils.toBlockPos(new Vec3(e.getX(), e.getY(), e.getZ())), mahou.getMentalDisplacementPos()) >= MTConfig.MENTAL_DISPLACEMENT_RANGE && !e.level().isClientSide) {
            mahou.setMentalDisplacementPos(null);
        }
    }

    public static int checkDistance(BlockPos a, BlockPos b) {
        if (a == null || b == null) {
            return 0;
        }
        return Math.max(Math.max(Math.abs(a.getX() - b.getX()), Math.abs(a.getY() - b.getY())), Math.abs(a.getZ() - b.getZ()));
    }
}

