/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.util;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.material.IMaterialCategory;

public enum CastingMaterialCategories implements IMaterialCategory
{
    CASTING,
    INFUSING,
    CRUDE;

    private static final Map<String, IMaterialCategory> CACHE;
    public static final Codec<IMaterialCategory> CODEC;
    public static final StreamCodec<FriendlyByteBuf, IMaterialCategory> STREAM_CODEC;

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static IMaterialCategory get(String key) {
        return CACHE.computeIfAbsent(key, key1 -> {
            for (CastingMaterialCategories cat : CastingMaterialCategories.values()) {
                if (!cat.getName().equalsIgnoreCase((String)key1)) continue;
                return cat;
            }
            String key2 = key1.toLowerCase(Locale.ROOT);
            return () -> key2;
        });
    }

    static {
        CACHE = new HashMap<String, IMaterialCategory>();
        CODEC = Codec.STRING.xmap(CastingMaterialCategories::get, IMaterialCategory::getName);
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, IMaterialCategory::getName, CastingMaterialCategories::get);
    }
}

