/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.datagen;

import cy.jdkdigital.sgearmetalworks.datagen.BeeProvider;
import cy.jdkdigital.sgearmetalworks.datagen.BlockModelProvider;
import cy.jdkdigital.sgearmetalworks.datagen.BlockTagProvider;
import cy.jdkdigital.sgearmetalworks.datagen.DamageTypeTagProvider;
import cy.jdkdigital.sgearmetalworks.datagen.DataMapProvider;
import cy.jdkdigital.sgearmetalworks.datagen.FluidTagProvider;
import cy.jdkdigital.sgearmetalworks.datagen.GuideBookProvider;
import cy.jdkdigital.sgearmetalworks.datagen.ItemModelProvider;
import cy.jdkdigital.sgearmetalworks.datagen.ItemTagProvider;
import cy.jdkdigital.sgearmetalworks.datagen.LanguageProvider;
import cy.jdkdigital.sgearmetalworks.datagen.MaterialsProvider;
import cy.jdkdigital.sgearmetalworks.datagen.RecipeProvider;
import cy.jdkdigital.sgearmetalworks.datagen.TraitsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="sgearmetalworks", bus=EventBusSubscriber.Bus.MOD)
public class MetalworksDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.getModContainer().getModId().equals("sgearmetalworks")) {
            Data.gatherData(event);
        }
    }

    static class Data {
        Data() {
        }

        private static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            PackOutput output = event.getGenerator().getPackOutput();
            CompletableFuture provider = event.getLookupProvider();
            ExistingFileHelper helper = event.getExistingFileHelper();
            gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output, "en_us"));
            gen.addProvider(event.includeClient(), (DataProvider)new BlockModelProvider(output));
            gen.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, helper));
            gen.addProvider(event.includeServer(), (DataProvider)new MaterialsProvider(gen));
            gen.addProvider(event.includeServer(), (DataProvider)new TraitsProvider(gen));
            gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
            gen.addProvider(event.includeServer(), (DataProvider)new BeeProvider(output, provider));
            if (ModList.get().isLoaded("patchouli")) {
                gen.addProvider(true, (DataProvider)new GuideBookProvider(output, "en_us", provider));
            }
            BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
            gen.addProvider(event.includeServer(), (DataProvider)blockTags);
            gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
            gen.addProvider(event.includeServer(), (DataProvider)new FluidTagProvider(output, provider, helper));
            gen.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagProvider(output, provider, helper));
            gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
        }
    }
}

