/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Stack;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.widgets.LogoWidget;
import journeymap.client.ui.component.widgets.UnscaledStringWidget;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public abstract class JmUI
extends Screen {
    protected final int topHeaderHeight = 24;
    protected final int bottomHeaderHeight = 12;
    protected final int headerHeight = 36;
    protected final int footerHeight = 30;
    protected final int centerHeight = 66;
    protected final String title;
    protected final Logger logger = Journeymap.getLogger();
    protected double scaleFactor = 1.0;
    public static Stack<Screen> returnDisplayStack = new Stack();
    private final boolean hasHeaderAndFooter;
    private LinearLayout headerLayout;
    private LogoWidget logoWidget;
    private StringWidget titleWidget;
    private UnscaledStringWidget apiVersionWidget;
    private FrameLayout spacerLeftHeader;
    private FrameLayout spacerRightHeader;
    protected LinearLayout footerLayout;
    protected boolean showLayoutDebug = false;
    protected FrameLayout contentLayout;
    protected boolean renderBackground = true;

    public JmUI(String title, boolean hasHeaderAndFooter) {
        this(title, hasHeaderAndFooter, null);
    }

    public JmUI(String title, boolean hasHeaderAndFooter, Screen returnDisplay) {
        super((Component)Constants.getStringTextComponent(title));
        this.title = title;
        this.hasHeaderAndFooter = hasHeaderAndFooter;
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.minecraft = Minecraft.getInstance();
        return this.minecraft;
    }

    public void init(Minecraft minecraft, int width, int height) {
        this.scaleFactor = JmUI.calculateScaleFactor();
        this.clearWidgets();
        super.init(minecraft, width, height);
        this.addAllRenderableLayouts();
    }

    public void init() {
        if (this.hasHeaderAndFooter) {
            this.headerLayout = LinearLayout.horizontal();
            this.headerLayout.spacing(0);
            this.logoWidget = (LogoWidget)this.headerLayout.addChild((LayoutElement)new LogoWidget(JmUI::calculateScaleFactor));
            this.spacerLeftHeader = (FrameLayout)this.headerLayout.addChild((LayoutElement)new FrameLayout(0, this.topHeaderHeight));
            this.titleWidget = (StringWidget)this.headerLayout.addChild((LayoutElement)new StringWidget(this.font.width(this.title) + 10, this.headerHeight, (Component)Component.literal((String)this.title), this.font).setColor(Color.CYAN.getRGB()));
            this.spacerRightHeader = (FrameLayout)this.headerLayout.addChild((LayoutElement)new FrameLayout(0, this.topHeaderHeight));
            String apiVersion = " API v2.0.0-SNAPSHOT ";
            this.apiVersionWidget = (UnscaledStringWidget)this.headerLayout.addChild((LayoutElement)new UnscaledStringWidget(0, this.headerHeight, (Component)Component.literal((String)apiVersion), this.font, JmUI::calculateScaleFactor).setColor(0xCCCCCC));
            this.footerLayout = LinearLayout.horizontal();
            this.footerLayout.spacing(12).defaultCellSetting().alignVerticallyMiddle();
            this.contentLayout = new FrameLayout(0, this.headerHeight, 0, 0);
        } else {
            this.contentLayout = new FrameLayout(0, 0, 0, 0);
        }
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    protected void rebuildWidgets() {
        super.rebuildWidgets();
        this.addAllRenderableLayouts();
    }

    private void addAllRenderableLayouts() {
        if (this.hasHeaderAndFooter) {
            this.headerLayout.visitWidgets(widget -> {
                this.addRenderableWidget((GuiEventListener)widget);
                widget.setTabOrderGroup(0);
            });
            this.footerLayout.visitWidgets(widget -> {
                this.addRenderableWidget((GuiEventListener)widget);
                widget.setTabOrderGroup(2);
            });
        }
        this.contentLayout.visitWidgets(widget -> {
            this.addRenderableWidget((GuiEventListener)widget);
            widget.setTabOrderGroup(1);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.scaleFactor = JmUI.calculateScaleFactor();
        if (this.hasHeaderAndFooter) {
            int fixedLeftHeaderWidth = this.logoWidget.getWidth() + this.titleWidget.getWidth() / 2;
            int fixedRightHeaderWidth = this.apiVersionWidget.getWidth() + this.titleWidget.getWidth() / 2;
            int halfWidth = this.width / 2;
            this.spacerLeftHeader.setMinWidth(halfWidth - fixedLeftHeaderWidth);
            this.spacerRightHeader.setMinWidth(halfWidth - fixedRightHeaderWidth);
            this.headerLayout.arrangeElements();
            this.footerLayout.arrangeElements();
            this.footerLayout.setPosition((this.width - this.footerLayout.getWidth()) / 2, this.height - (this.footerHeight + this.footerLayout.getHeight()) / 2);
            this.contentLayout.setMinDimensions(this.width, this.height - this.headerHeight - this.footerHeight);
        } else {
            this.contentLayout.setMinDimensions(this.width, this.height);
        }
        this.contentLayout.arrangeElements();
    }

    public static double calculateScaleFactor() {
        Minecraft minecraft = Minecraft.getInstance();
        double scaleFactor = minecraft.getWindow().getGuiScale();
        int monitorWidth = minecraft.getWindow().findBestMonitor().getCurrentMode().getWidth();
        int windowWidth = minecraft.getWindow().getWidth();
        int screenWidth = minecraft.getWindow().getScreenWidth();
        if ((Minecraft.ON_OSX || Services.COMMON_SERVICE.isModLoaded("qdaa")) && windowWidth > monitorWidth) {
            scaleFactor = minecraft.getWindow().getGuiScale() / ((double)windowWidth / (double)screenWidth);
            if (screenWidth == monitorWidth) {
                scaleFactor = minecraft.getWindow().getGuiScale() / ((double)windowWidth / (double)monitorWidth);
            }
        }
        return scaleFactor;
    }

    public static Point2D.Double getMousePos() {
        Minecraft minecraft = Minecraft.getInstance();
        double scale = JmUI.calculateScaleFactor();
        if (Minecraft.ON_OSX && scale != minecraft.getWindow().getGuiScale()) {
            double d3 = minecraft.mouseHandler.xpos() * scale;
            double d4 = minecraft.mouseHandler.ypos() * scale;
            return new Point2D.Double(d3, d4);
        }
        return new Point2D.Double(minecraft.mouseHandler.xpos(), minecraft.mouseHandler.ypos());
    }

    public boolean isPauseScreen() {
        return true;
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        if (Minecraft.getInstance().level == null) {
            this.drawGradientRect(graphics, 0, 0, this.width, this.height, -1072689136, -804253680, 0);
        } else {
            super.renderBackground(graphics, i, j, f);
        }
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.renderBackground) {
            this.renderBackground(graphics, x, y, partialTicks);
        }
        if (this.hasHeaderAndFooter) {
            DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.width, 36.0, 0, 0.9f);
            DrawUtil.drawRectangle(graphics, 0.0, this.height - 30, this.width, this.height, 0, 0.6f);
        }
        List<FormattedCharSequence> tooltip = null;
        for (Renderable renderable : this.getRenderables()) {
            Button button;
            renderable.render(graphics, x, y, partialTicks);
            if (tooltip != null || !(renderable instanceof Button) || !(button = (Button)renderable).mouseOver(x, y)) continue;
            tooltip = button.getWrappedTooltip();
        }
        if (this.showLayoutDebug) {
            JmUI.debugLayoutRender(graphics, (LayoutElement)this.headerLayout);
            JmUI.debugLayoutRender(graphics, (LayoutElement)this.contentLayout);
            JmUI.debugLayoutRender(graphics, (LayoutElement)this.footerLayout);
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            this.renderWrappedToolTip(graphics, tooltip, x, y, this.getFontRenderer());
        }
    }

    public void drawGradientRect(GuiGraphics graphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        graphics.fillGradient(RenderType.guiOverlay(), pX1, pY1, pX2, pY2, pColorFrom, pColorTo, pBlitOffset);
    }

    protected void closeAndReturn() {
        this.onClose();
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public void closeWithKeyBind() {
        this.closeAndReturn();
    }

    public boolean keyPressed(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.keyPressed(key, value, modifier);
    }

    public void renderWrappedToolTip(GuiGraphics graphics, List tooltip, int mouseX, int mouseY, Font fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof FormattedCharSequence && Minecraft.getInstance().screen == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (FormattedCharSequence line : tooltip) {
                int lineWidth = fontRenderer.width(line);
                if (fontRenderer.isBidirectional()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.width) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.height) {
                drawY = this.height - boxHeight - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                FormattedCharSequence line = (FormattedCharSequence)tooltip.get(i2);
                Matrix4f matrixPos = graphics.pose().last().pose();
                if (fontRenderer.isBidirectional()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.width(line) * 1.1);
                    fontRenderer.drawInBatch(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1, true, matrixPos, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    fontRenderer.drawInBatch(line, (float)drawX, (float)drawY, -1, true, matrixPos, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    public List<Renderable> getRenderables() {
        return this.renderables;
    }

    protected void outline(GuiGraphics graphics, int x, int y, int width, int height) {
        int color = 0xC0C0C0;
        float alpha = 0.8f;
        DrawUtil.drawRectangle(graphics, x, y, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y + height, width, 1.0, color, alpha);
        DrawUtil.drawRectangle(graphics, x, y, 1.0, height, color, alpha);
        DrawUtil.drawRectangle(graphics, x + width, y, 1.0, height + 1, color, alpha);
    }

    private static void debugLayoutRender(GuiGraphics graphics, LayoutElement lElement) {
        int hash = lElement.hashCode();
        int color = Color.HSBtoRGB((float)(hash % 256) / 255.0f, (float)(hash % 128) / 127.0f + 128.0f, (float)(hash % 128) / 127.0f + 128.0f);
        DrawUtil.drawRectangle(graphics, lElement.getX(), lElement.getY(), lElement.getWidth(), 1.0, color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.getX(), lElement.getY(), 1.0, lElement.getHeight(), color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.getX(), lElement.getY() + lElement.getHeight() - 1, lElement.getWidth() - 1, 1.0, color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.getX() + lElement.getWidth() - 1, lElement.getY() + 1, 1.0, lElement.getHeight() - 1, color, 0.8f);
        if (lElement instanceof Layout) {
            Layout layout = (Layout)lElement;
            layout.visitChildren(l -> JmUI.debugLayoutRender(graphics, l));
        }
    }
}

