/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ForgeHandlerUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemHandlerInsertableStorage
implements InsertableStorage {
    private final CapabilityCache capabilityCache;

    public ItemHandlerInsertableStorage(CapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> ForgeHandlerUtil.getCurrentAmount(itemHandler, itemResource.toItemStack())).orElse(0L);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof ItemResource)) {
            return 0L;
        }
        ItemResource itemResource = (ItemResource)resource;
        return this.capabilityCache.getItemHandler().map(itemHandler -> this.insert(itemResource, amount, action, (IItemHandler)itemHandler)).orElse(0L);
    }

    private long insert(ItemResource resource, long amount, Action action, IItemHandler itemHandler) {
        ItemStack stack = resource.toItemStack(amount);
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (action == Action.SIMULATE ? 1 : 0) != 0);
        return amount - (long)remainder.getCount();
    }
}

