/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.debug;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DebugStickItem
extends Item {
    public DebugStickItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        if (blockEntity != null) {
            DebugStickItem.dump(level, blockEntity, player);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide()) {
            ItemStack storageDisk = new ItemStack((ItemLike)Items.INSTANCE.getItemStorageDisk(ItemStorageVariant.CREATIVE));
            storageDisk.inventoryTick(level, (Entity)player, 0, false);
            ((StorageContainerItem)storageDisk.getItem()).resolve(RefinedStorageApi.INSTANCE.getStorageRepository(level), storageDisk).ifPresent(storage -> {
                int size = 0;
                for (Item item : BuiltInRegistries.ITEM) {
                    ItemStack stack = item.getDefaultInstance();
                    if (stack.isDamageableItem() && player.isCrouching()) {
                        for (int i = 0; i < stack.getMaxDamage(); ++i) {
                            ItemStack damaged = stack.copy();
                            damaged.setDamageValue(i);
                            storage.insert(ItemResource.ofItemStack(damaged), Integer.MAX_VALUE, Action.EXECUTE, Actor.EMPTY);
                            ++size;
                        }
                        continue;
                    }
                    storage.insert(ItemResource.ofItemStack(stack), Integer.MAX_VALUE, Action.EXECUTE, Actor.EMPTY);
                    ++size;
                }
                player.getInventory().add(storageDisk);
                player.sendSystemMessage((Component)Component.literal((String)("Gave a storage disk with " + size + " item types")));
            });
        }
        return super.use(level, player, usedHand);
    }

    private static void dump(Level level, BlockEntity blockEntity, Player player) {
        if (level.isClientSide()) {
            return;
        }
        if (!(blockEntity instanceof AbstractBaseNetworkNodeContainerBlockEntity)) {
            return;
        }
        AbstractBaseNetworkNodeContainerBlockEntity provider = (AbstractBaseNetworkNodeContainerBlockEntity)blockEntity;
        provider.getContainerProvider().getContainers().forEach(container -> DebugStickItem.dump(player, container));
        player.sendSystemMessage((Component)Component.literal((String)"---"));
    }

    private static void dump(Player player, InWorldNetworkNodeContainer container) {
        Network network = container.getNode().getNetwork();
        player.sendSystemMessage((Component)Component.literal((String)(container.getNode().getClass().getSimpleName() + " --> ")).append((Component)(network == null ? Component.literal((String)"<NULL>").withStyle(ChatFormatting.RED) : Component.literal((String)("" + network.hashCode())).withStyle(ChatFormatting.AQUA))));
        if (network != null) {
            DebugStickItem.dump(player, network);
        }
    }

    private static void dump(Player player, Network network) {
        Map nodesByType = network.getComponent(GraphNetworkComponent.class).getContainers().stream().map(c -> c.getNode().getClass().getSimpleName()).reduce(new LinkedHashMap(), (map, name) -> {
            map.put(name, map.getOrDefault(name, 0) + 1);
            return map;
        }, (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        });
        nodesByType.forEach((type, amount) -> player.sendSystemMessage((Component)Component.literal((String)(amount + "x ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)type).withStyle(ChatFormatting.GOLD))));
    }
}

