/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SchedulingModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "scheduling_mode");
    private static final ResourceLocation DEFAULT = IdentifierUtil.createIdentifier("widget/side_button/scheduling_mode/default");
    private static final ResourceLocation ROUND_ROBIN = IdentifierUtil.createIdentifier("widget/side_button/scheduling_mode/round_robin");
    private static final ResourceLocation RANDOM = IdentifierUtil.createIdentifier("widget/side_button/scheduling_mode/random");
    private final ClientProperty<SchedulingModeType> property;

    public SchedulingModeSideButtonWidget(ClientProperty<SchedulingModeType> property) {
        super(SchedulingModeSideButtonWidget.createPressAction(property));
        this.property = property;
    }

    private static Button.OnPress createPressAction(ClientProperty<SchedulingModeType> property) {
        return btn -> property.setValue(SchedulingModeSideButtonWidget.toggle((SchedulingModeType)((Object)((Object)property.getValue()))));
    }

    private static SchedulingModeType toggle(SchedulingModeType modeSettings) {
        return switch (modeSettings) {
            default -> throw new MatchException(null, null);
            case SchedulingModeType.DEFAULT -> SchedulingModeType.ROUND_ROBIN;
            case SchedulingModeType.ROUND_ROBIN -> SchedulingModeType.RANDOM;
            case SchedulingModeType.RANDOM -> SchedulingModeType.DEFAULT;
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.property.getValue()) {
            default -> throw new MatchException(null, null);
            case SchedulingModeType.DEFAULT -> DEFAULT;
            case SchedulingModeType.ROUND_ROBIN -> ROUND_ROBIN;
            case SchedulingModeType.RANDOM -> RANDOM;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return List.of(this.property.getValue().getName().copy().withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected Component getHelpText() {
        return this.property.getValue().getHelpText();
    }
}

