/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractYesNoSideButtonWidget
extends AbstractSideButtonWidget {
    private static final List<MutableComponent> YES_LINES = List.of(IdentifierUtil.YES.copy().withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> NO_LINES = List.of(IdentifierUtil.NO.copy().withStyle(ChatFormatting.GRAY));
    private final ClientProperty<Boolean> property;
    private final MutableComponent title;
    private final ResourceLocation yesSprite;
    private final ResourceLocation noSprite;

    protected AbstractYesNoSideButtonWidget(ClientProperty<Boolean> property, MutableComponent title, ResourceLocation yesSprite, ResourceLocation noSprite) {
        super(AbstractYesNoSideButtonWidget.createPressAction(property));
        this.property = property;
        this.title = title;
        this.yesSprite = yesSprite;
        this.noSprite = noSprite;
    }

    private static Button.OnPress createPressAction(ClientProperty<Boolean> property) {
        return btn -> property.setValue((Boolean)property.getValue() == false);
    }

    @Override
    protected ResourceLocation getSprite() {
        return Boolean.TRUE.equals(this.property.getValue()) ? this.yesSprite : this.noSprite;
    }

    @Override
    protected MutableComponent getTitle() {
        return this.title;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return Boolean.TRUE.equals(this.property.getValue()) ? YES_LINES : NO_LINES;
    }
}

