/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class FluidResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));
    private final long bucketAmount;

    public FluidResourceRendering(long bucketAmount) {
        this.bucketAmount = bucketAmount;
    }

    @Override
    public String formatAmount(long amount, boolean withUnits) {
        return (!withUnits ? FluidResourceRendering.format(amount, this.bucketAmount) : FluidResourceRendering.formatWithUnits(amount, this.bucketAmount)) + "B";
    }

    @Override
    public Component getDisplayName(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return Component.empty();
        }
        FluidResource fluidResource = (FluidResource)resource;
        return Platform.INSTANCE.getFluidRenderer().getDisplayName(fluidResource);
    }

    @Override
    public List<Component> getTooltip(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return Collections.emptyList();
        }
        FluidResource fluidResource = (FluidResource)resource;
        return Platform.INSTANCE.getFluidRenderer().getTooltip(fluidResource);
    }

    @Override
    public void render(ResourceKey resource, GuiGraphics graphics, int x, int y) {
        if (!(resource instanceof FluidResource)) {
            return;
        }
        FluidResource fluidResource = (FluidResource)resource;
        Platform.INSTANCE.getFluidRenderer().render(graphics.pose(), x, y, fluidResource);
    }

    @Override
    public void render(ResourceKey resource, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, Level level) {
        if (!(resource instanceof FluidResource)) {
            return;
        }
        FluidResource fluidResource = (FluidResource)resource;
        Platform.INSTANCE.getFluidRenderer().render(poseStack, renderTypeBuffer, light, fluidResource);
    }

    private static String formatWithUnits(long droplets, long bucketAmount) {
        double buckets = FluidResourceRendering.convertToBuckets(droplets, bucketAmount);
        return IdentifierUtil.formatWithUnits(buckets);
    }

    private static String format(long droplets, long bucketAmount) {
        double buckets = FluidResourceRendering.convertToBuckets(droplets, bucketAmount);
        return FORMATTER.format(buckets);
    }

    private static double convertToBuckets(long droplets, long bucketAmount) {
        return (double)droplets / (double)bucketAmount;
    }
}

