/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record StorageInfoRequestPacket(UUID storageId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StorageInfoRequestPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("storage_info_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageInfoRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, StorageInfoRequestPacket::storageId, StorageInfoRequestPacket::new);

    public static void handle(StorageInfoRequestPacket packet, PacketContext ctx) {
        Player player = ctx.getPlayer();
        StorageInfo info = RefinedStorageApi.INSTANCE.getStorageRepository(player.getCommandSenderWorld()).getInfo(packet.storageId());
        S2CPackets.sendStorageInfoResponse((ServerPlayer)player, packet.storageId, info);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

