/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class RecipeMatrix<T extends Recipe<I>, I extends RecipeInput> {
    private final Runnable listener;
    private final Supplier<@NullableType Level> levelSupplier;
    private final RecipeMatrixContainer matrix;
    private final ResultContainer craftingResult = new ResultContainer();
    private final Function<RecipeMatrixContainer, I> inputProvider;
    private final RecipeType<T> recipeType;
    @Nullable
    private RecipeHolder<T> currentRecipe;

    public RecipeMatrix(Runnable listener, Supplier<@NullableType Level> levelSupplier, int width, int height, Function<RecipeMatrixContainer, I> inputProvider, RecipeType<T> recipeType) {
        this.listener = listener;
        this.levelSupplier = levelSupplier;
        this.matrix = new RecipeMatrixContainer(this::matrixChanged, width, height);
        this.inputProvider = inputProvider;
        this.recipeType = recipeType;
    }

    public static RecipeMatrix<CraftingRecipe, CraftingInput> crafting(Runnable listener, Supplier<@NullableType Level> levelSupplier) {
        return new RecipeMatrix<CraftingRecipe, CraftingInput>(listener, levelSupplier, 3, 3, CraftingContainer::asCraftInput, RecipeType.CRAFTING);
    }

    public static RecipeMatrix<SmithingRecipe, SmithingRecipeInput> smithingTable(Runnable listener, Supplier<@NullableType Level> levelSupplier) {
        return new RecipeMatrix<SmithingRecipe, SmithingRecipeInput>(listener, levelSupplier, 3, 1, slots -> new SmithingRecipeInput(slots.getItem(0), slots.getItem(1), slots.getItem(2)), RecipeType.SMITHING);
    }

    private void matrixChanged() {
        Level level = this.levelSupplier.get();
        if (level == null) {
            return;
        }
        this.updateResult(level);
        this.listener.run();
    }

    public void clear(Level level) {
        this.matrix.clearContent();
        this.updateResult(level);
    }

    public void updateResult(Level level) {
        if (level.isClientSide() || this.matrix.isMuted()) {
            return;
        }
        RecipeInput input = (RecipeInput)this.inputProvider.apply(this.matrix);
        if (this.currentRecipe == null || !this.currentRecipe.value().matches(input, level)) {
            this.currentRecipe = this.loadRecipe(level);
        }
        if (this.currentRecipe == null) {
            this.setResult(null, ItemStack.EMPTY);
        } else {
            this.setResult(this.currentRecipe, this.currentRecipe.value().assemble(input, (HolderLookup.Provider)level.registryAccess()));
        }
    }

    public RecipeMatrixContainer getMatrix() {
        return this.matrix;
    }

    public ResultContainer getResult() {
        return this.craftingResult;
    }

    public boolean hasResult() {
        return !this.craftingResult.getItem(0).isEmpty();
    }

    private void setResult(@Nullable RecipeHolder<?> recipe, ItemStack result) {
        this.craftingResult.setRecipeUsed(recipe);
        this.craftingResult.setItem(0, result);
    }

    @Nullable
    private RecipeHolder<T> loadRecipe(Level level) {
        return level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)this.inputProvider.apply(this.matrix), level).orElse(null);
    }

    public NonNullList<ItemStack> getRemainingItems(@Nullable Level level, Player player, CraftingInput input) {
        Recipe recipe;
        if (level == null || this.currentRecipe == null || !((recipe = this.currentRecipe.value()) instanceof CraftingRecipe)) {
            return NonNullList.create();
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        return Platform.INSTANCE.getRemainingCraftingItems(player, craftingRecipe, input);
    }

    public CompoundTag writeToTag(HolderLookup.Provider provider) {
        return ContainerUtil.write((Container)this.matrix, provider);
    }

    public void readFromTag(CompoundTag tag, HolderLookup.Provider provider) {
        ContainerUtil.read(tag, (Container)this.matrix, provider);
    }
}

