/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.storage.portablegrid.AbstractPortableGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.widget.ProgressWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class PortableGridScreen
extends AbstractGridScreen<AbstractPortableGridContainerMenu> {
    private static final int DISK_SLOT_WIDTH = 30;
    private static final int DISK_SLOT_HEIGHT = 26;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/portable_grid.png");
    @Nullable
    private ProgressWidget progressWidget;

    public PortableGridScreen(AbstractPortableGridContainerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 99);
        this.inventoryLabelY = 75;
        this.imageWidth = 193;
        this.imageHeight = 176;
    }

    @Override
    protected int getSideButtonY() {
        return super.getSideButtonY() + 26;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int leftPos, int topPos, int clickedButton) {
        if (mouseX >= (double)(leftPos - 30 + 3) && mouseX <= (double)leftPos && mouseY >= (double)(topPos + 3) && mouseY <= (double)(topPos + 3 + 26)) {
            return false;
        }
        return super.hasClickedOutside(mouseX, mouseY, leftPos, topPos, clickedButton);
    }

    @Override
    protected void init() {
        super.init();
        this.getExclusionZones().add(new Rect2i(this.leftPos - 30 + 3, this.topPos + 3, 30, 26));
        int progressX = 172;
        int progressY = this.imageHeight - 10 - 70;
        if (this.progressWidget == null) {
            this.progressWidget = new ProgressWidget(this.leftPos + 172, this.topPos + progressY, 16, 70, ((AbstractPortableGridContainerMenu)this.getMenu()).getEnergyInfo()::getPercentageFull, ((AbstractPortableGridContainerMenu)this.getMenu()).getEnergyInfo()::createTooltip);
        } else {
            this.progressWidget.setX(this.leftPos + 172);
            this.progressWidget.setY(this.topPos + progressY);
        }
        this.addRenderableWidget((GuiEventListener)this.progressWidget);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.getTexture(), x - 30 + 3, y + 3, 226, 0, 30, 26);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

