/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.AbstractDiskContainerBlockEntity;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceContainerMenu;
import com.refinedmods.refinedstorage.common.storage.diskinterface.TransferModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractDiskInterfaceBlockEntity
extends AbstractDiskContainerBlockEntity<StorageTransferNetworkNode>
implements StorageTransferListener {
    public static final int AMOUNT_OF_DISKS = 6;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_TRANSFER_MODE = "tm";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.DISK_INTERFACE, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsage();
        ((StorageTransferNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.setChanged();
    });

    protected AbstractDiskInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getDiskInterface(), pos, state, new StorageTransferNetworkNode(Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsage(), Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsagePerDisk(), 6));
        this.ticker = this.upgradeContainer.getTicker();
        ((StorageTransferNetworkNode)this.mainNetworkNode).setListener(this);
        ((StorageTransferNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(storage -> {
            if (storage instanceof SerializableStorage) {
                SerializableStorage serializableStorage = (SerializableStorage)storage;
                return serializableStorage.getType().getDiskInterfaceTransferQuota(this.upgradeContainer.has(Items.INSTANCE.getStackUpgrade()));
            }
            return 1L;
        });
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setNormalizer(normalizer);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((StorageTransferNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_TRANSFER_MODE)) {
            ((StorageTransferNetworkNode)this.mainNetworkNode).setMode(TransferModeSettings.getTransferMode(tag.getInt(TAG_TRANSFER_MODE)));
        }
        if (tag.contains(TAG_FILTER_MODE)) {
            ((StorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.getInt(TAG_FILTER_MODE)));
        }
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_TRANSFER_MODE, TransferModeSettings.getTransferMode(((StorageTransferNetworkNode)this.mainNetworkNode).getMode()));
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.DISK_INTERFACE);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new DiskInterfaceContainerMenu(syncId, player, this, this.diskInventory, this.filter.getFilterContainer(), this.upgradeContainer);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (int i = 0; i < this.upgradeContainer.getContainerSize(); ++i) {
            drops.add((Object)this.upgradeContainer.getItem(i));
        }
        return drops;
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.setChanged();
    }

    FilterMode getFilterMode() {
        return ((StorageTransferNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    public StorageTransferMode getTransferMode() {
        return ((StorageTransferNetworkNode)this.mainNetworkNode).getMode();
    }

    public void setTransferMode(StorageTransferMode mode) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setMode(mode);
        this.setChanged();
    }

    @Override
    public void onTransferSuccess(int index) {
        ItemStack diskStack = this.diskInventory.getItem(index);
        if (diskStack.isEmpty()) {
            return;
        }
        for (int newIndex = 3; newIndex < 6; ++newIndex) {
            if (!this.diskInventory.getItem(newIndex).isEmpty()) continue;
            this.diskInventory.setItem(index, ItemStack.EMPTY);
            this.diskInventory.setItem(newIndex, diskStack);
            return;
        }
    }
}

