/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.security.SecurityManagerBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SecurityManagerContainerMenu
extends AbstractBaseContainerMenu {
    private final Predicate<Player> stillValid;
    @Nullable
    private Slot fallbackSecurityCardSlot;

    public SecurityManagerContainerMenu(int syncId, Inventory playerInventory) {
        super(Menus.INSTANCE.getSecurityManager(), syncId);
        this.addSlots(playerInventory, new FilteredContainer(18, SecurityManagerBlockEntity::isValidSecurityCard), new FilteredContainer(1, SecurityManagerBlockEntity::isValidFallbackSecurityCard));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.stillValid = player -> true;
    }

    SecurityManagerContainerMenu(int syncId, Inventory playerInventory, SecurityManagerBlockEntity securityManager) {
        super(Menus.INSTANCE.getSecurityManager(), syncId);
        this.addSlots(playerInventory, securityManager.getSecurityCards(), securityManager.getFallbackSecurityCard());
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, securityManager::getRedstoneMode, securityManager::setRedstoneMode));
        this.stillValid = player -> Container.stillValidBlockEntity((BlockEntity)securityManager, (Player)player);
    }

    private void addSlots(Inventory playerInventory, FilteredContainer securityCards, FilteredContainer fallbackSecurityCard) {
        for (int i = 0; i < 18; ++i) {
            int column = i % 9;
            int x = 8 + column * 18;
            int row = i / 9;
            int y = 20 + row * 18;
            this.addSlot(new ValidatedSlot((Container)securityCards, i, x, y, SecurityManagerBlockEntity::isValidSecurityCard));
        }
        this.fallbackSecurityCardSlot = new ValidatedSlot((Container)fallbackSecurityCard, 0, 174, 20, SecurityManagerBlockEntity::isValidFallbackSecurityCard);
        this.addSlot(this.fallbackSecurityCardSlot);
        this.addPlayerInventory(playerInventory, 8, 72);
        this.transferManager.addBiTransfer((Container)playerInventory, (Container)securityCards);
        this.transferManager.addBiTransfer((Container)playerInventory, (Container)fallbackSecurityCard);
    }

    @Nullable
    Slot getFallbackSecurityCardSlot() {
        return this.fallbackSecurityCardSlot;
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

