/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.security.SecurityPolicyContainerItem;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.SecurityCardPermissions;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

abstract class AbstractSecurityCardItem<T>
extends Item
implements SecurityPolicyContainerItem {
    protected AbstractSecurityCardItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        this.getPolicy(stack).ifPresent(policy -> this.appendHoverText(lines, (SecurityPolicy)policy, this.getDirtyPermissions(stack)));
    }

    private void appendHoverText(List<Component> lines, SecurityPolicy policy, Set<PlatformPermission> dirtyPermissions) {
        List<PlatformPermission> allPermissions = RefinedStorageApi.INSTANCE.getPermissionRegistry().getAll();
        allPermissions.forEach(permission -> {
            boolean allowed = policy.isAllowed((Permission)permission);
            boolean dirty = dirtyPermissions.contains(permission);
            Style style = Style.EMPTY.withColor(allowed ? ChatFormatting.GREEN : ChatFormatting.RED).withItalic(Boolean.valueOf(dirty));
            MutableComponent permissionTooltip = Component.literal((String)(allowed ? "\u2713 " : "\u274c ")).append(permission.getName()).append(dirty ? " (*)" : "").withStyle(style);
            lines.add((Component)permissionTooltip);
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.doUse(hand, serverPlayer, stack);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    private void doUse(InteractionHand hand, ServerPlayer player, ItemStack stack) {
        if (player.isCrouching()) {
            this.clearConfiguration(player, stack);
            return;
        }
        this.getPolicy(stack).ifPresent(policy -> {
            Set<PlatformPermission> dirtyPermissions = this.getDirtyPermissions(stack);
            Platform.INSTANCE.getMenuOpener().openMenu(player, this.createMenuProvider(player.server, RefinedStorageApi.INSTANCE.createInventorySlotReference((Player)player, hand), (SecurityPolicy)policy, dirtyPermissions, stack));
        });
    }

    private void clearConfiguration(ServerPlayer player, ItemStack stack) {
        stack.remove(DataComponents.INSTANCE.getSecurityCardPermissions());
        player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "security_card.cleared_configuration"));
    }

    abstract AbstractSecurityCardExtendedMenuProvider<T> createMenuProvider(MinecraftServer var1, SlotReference var2, SecurityPolicy var3, Set<PlatformPermission> var4, ItemStack var5);

    @Override
    public Optional<SecurityPolicy> getPolicy(ItemStack stack) {
        if (!this.isValid(stack)) {
            return Optional.empty();
        }
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.get(DataComponents.INSTANCE.getSecurityCardPermissions());
        if (permissions == null) {
            return Optional.of(RefinedStorageApi.INSTANCE.createDefaultSecurityPolicy());
        }
        return Optional.of(this.createPolicy(permissions));
    }

    private SecurityPolicy createPolicy(SecurityCardPermissions permissions) {
        HashSet<Permission> allowedPermissions = new HashSet<Permission>();
        for (PlatformPermission permission : RefinedStorageApi.INSTANCE.getPermissionRegistry().getAll()) {
            boolean isAllowedByDefault;
            boolean dirty = permissions.isDirty(permission);
            boolean didExplicitlyAllow = dirty && permissions.isAllowed(permission);
            boolean bl = isAllowedByDefault = !dirty && permission.isAllowedByDefault();
            if (!didExplicitlyAllow && !isAllowedByDefault) continue;
            allowedPermissions.add(permission);
        }
        return new SecurityPolicy(allowedPermissions);
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return true;
    }

    Set<PlatformPermission> getDirtyPermissions(ItemStack stack) {
        return ((SecurityCardPermissions)stack.getOrDefault(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY)).permissions().keySet();
    }

    void setPermission(ItemStack stack, PlatformPermission permission, boolean allowed) {
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.getOrDefault(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY);
        stack.set(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)permissions.withPermission(permission, allowed));
    }

    void resetPermission(ItemStack stack, PlatformPermission permission) {
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.getOrDefault(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY);
        stack.set(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)permissions.forgetPermission(permission));
    }
}

