/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WirelessTransmitterBlock
extends AbstractActiveColoredDirectionalBlock<Direction, WirelessTransmitterBlock, BaseBlockItem>
implements BlockItemProvider<BaseBlockItem>,
EntityBlock {
    private static final AbstractBlockEntityTicker<WirelessTransmitterBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getWirelessTransmitter, ACTIVE);
    private static final Component HELP = IdentifierUtil.createTranslation("item", "wireless_transmitter.help");
    private static final VoxelShape SHAPE_DOWN = WirelessTransmitterBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = WirelessTransmitterBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_EAST = WirelessTransmitterBlock.box((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_WEST = WirelessTransmitterBlock.box((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = WirelessTransmitterBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = WirelessTransmitterBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);

    public WirelessTransmitterBlock(DyeColor color, MutableComponent name) {
        super(BlockConstants.PROPERTIES, color, name);
    }

    @Override
    protected DirectionType<Direction> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)this.getDirection(state);
        if (direction == null) {
            return Shapes.empty();
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    @Override
    public BlockColorMap<WirelessTransmitterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getWirelessTransmitter();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WirelessTransmitterBlockEntity(pos, state);
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

