/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.networking.TransmittingIcon;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetworkTransmitterScreen
extends AbstractBaseScreen<NetworkTransmitterContainerMenu> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/network_transmitter.png");
    private final TransmittingIcon icon;

    public NetworkTransmitterScreen(NetworkTransmitterContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.inventoryLabelY = 42;
        this.imageWidth = 176;
        this.imageHeight = 137;
        this.icon = new TransmittingIcon(this.isIconActive());
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RedstoneModeSideButtonWidget(((NetworkTransmitterContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
    }

    protected void containerTick() {
        super.containerTick();
        this.icon.tick(this.isIconActive());
    }

    private boolean isIconActive() {
        return !((NetworkTransmitterContainerMenu)this.getMenu()).getStatus().error() && ((NetworkTransmitterContainerMenu)this.getMenu()).getStatus().transmitting();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        this.icon.render(graphics, this.leftPos + 29, this.topPos + 22);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        NetworkTransmitterData status = ((NetworkTransmitterContainerMenu)this.getMenu()).getStatus();
        int x = 29 + this.icon.getWidth() + 4;
        if (status.error()) {
            graphics.blitSprite(Sprites.WARNING, x, 23, 10, 10);
        }
        graphics.drawString(this.font, status.message(), x + (status.error() ? 14 : 0), 25, 0x404040, false);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

