/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.importer;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.importer.AbstractImporterBlockEntity;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSimpleFilterContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class ImporterContainerMenu
extends AbstractSimpleFilterContainerMenu<AbstractImporterBlockEntity> {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation("gui", "importer.filter_help");
    private final Predicate<Player> stillValid;

    public ImporterContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getImporter(), syncId, playerInventory.player, resourceContainerData, UpgradeDestinations.IMPORTER, (Component)FILTER_HELP);
        this.stillValid = p -> true;
    }

    ImporterContainerMenu(int syncId, Player player, AbstractImporterBlockEntity importer, ResourceContainer resourceContainer, UpgradeContainer upgradeContainer, Predicate<Player> stillValid) {
        super(Menus.INSTANCE.getImporter(), syncId, player, resourceContainer, upgradeContainer, importer, (Component)FILTER_HELP);
        this.stillValid = stillValid;
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty(new ClientProperty<FilterMode>(PropertyTypes.FILTER_MODE, FilterMode.BLOCK));
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
    }

    @Override
    protected void registerServerProperties(AbstractImporterBlockEntity blockEntity) {
        this.registerProperty(new ServerProperty<FilterMode>(PropertyTypes.FILTER_MODE, blockEntity::getFilterMode, blockEntity::setFilterMode));
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

