/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.exporter.CompositeExporterTransferStrategy;
import com.refinedmods.refinedstorage.common.exporter.ExporterContainerMenu;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporterBlockEntity
extends AbstractCableLikeBlockEntity<ExporterNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ExporterData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExporterBlockEntity.class);
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.EXPORTER, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getExporter().getEnergyUsage();
        ((ExporterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.setChanged();
        Level patt0$temp = this.level;
        if (patt0$temp instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            this.initialize(serverLevel);
        }
    });
    private final FilterWithFuzzyMode filter;
    private final SchedulingModeContainer schedulingModeContainer;

    protected AbstractExporterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getExporter(), pos, state, new ExporterNetworkNode(Platform.INSTANCE.getConfig().getExporter().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
        this.schedulingModeContainer = new SchedulingModeContainer(this::schedulingModeChanged);
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractExporterBlockEntity)this).setChanged(), this::setFilters);
    }

    private void schedulingModeChanged(SchedulingMode schedulingMode) {
        ((ExporterNetworkNode)this.mainNetworkNode).setSchedulingMode(schedulingMode);
        this.setChanged();
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ExporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized exporter at {} with strategy {}", (Object)this.worldPosition, (Object)strategy);
        ((ExporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ExporterTransferStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        List<ExporterTransferStrategyFactory> factories = RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().getAll();
        Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies = factories.stream().collect(Collectors.toMap(ExporterTransferStrategyFactory::getResourceType, factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer, this.filter.isFuzzyMode())));
        return new CompositeExporterTransferStrategy(strategies);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.schedulingModeContainer.writeToTag(tag);
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.schedulingModeContainer.loadFromTag(tag);
        this.filter.load(tag, provider);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.EXPORTER);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new ExporterContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((ExporterNetworkNode)this.mainNetworkNode).getLastResult(i)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ExporterTransferStrategy.Result result) {
        ExporterTransferStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"DESTINATION_DOES_NOT_ACCEPT", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ExporterTransferStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public ExporterData getMenuData() {
        ResourceContainer filterContainer = this.filter.getFilterContainer();
        ResourceContainerData resourceContainerData = ResourceContainerData.of(filterContainer);
        return new ExporterData(resourceContainerData, this.getExportingIndicators().getAll());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ExporterData> getMenuCodec() {
        return ExporterData.STREAM_CODEC;
    }

    void setFilters(List<ResourceKey> filters) {
        ((ExporterNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

