/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

abstract class AbstractItemConstructorStrategy
implements ConstructorStrategy {
    protected final ServerLevel level;
    protected final BlockPos pos;
    protected final Direction direction;

    AbstractItemConstructorStrategy(ServerLevel level, BlockPos pos, Direction direction) {
        this.level = level;
        this.pos = pos;
        this.direction = direction;
    }

    protected long getTransferAmount() {
        return 1L;
    }

    @Override
    public final ConstructorStrategy.Result apply(ResourceKey resource, Actor actor, Player player, Network network) {
        long amount;
        if (!this.level.isLoaded(this.pos) || !(resource instanceof ItemResource)) {
            return ConstructorStrategy.Result.SKIPPED;
        }
        ItemResource itemResource = (ItemResource)resource;
        if (!this.hasWork()) {
            return ConstructorStrategy.Result.SUCCESS;
        }
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        long extractedAmount = rootStorage.extract(itemResource, amount = this.getTransferAmount(), Action.SIMULATE, actor);
        if (extractedAmount == 0L) {
            return ConstructorStrategy.Result.RESOURCE_MISSING;
        }
        ItemStack itemStack = itemResource.toItemStack(extractedAmount);
        boolean success = this.apply(itemStack, actor, player);
        if (success) {
            rootStorage.extract(itemResource, extractedAmount, Action.EXECUTE, actor);
        }
        return success ? ConstructorStrategy.Result.SUCCESS : ConstructorStrategy.Result.SKIPPED;
    }

    protected abstract boolean apply(ItemStack var1, Actor var2, Player var3);

    protected abstract boolean hasWork();

    protected double getDispensePositionX() {
        return (double)this.pos.getX() + 0.5;
    }

    protected double getDispensePositionY() {
        return (double)this.pos.getY() + (this.direction == Direction.DOWN ? 0.45 : 0.5);
    }

    protected double getDispensePositionZ() {
        return (double)this.pos.getZ() + 0.5;
    }
}

