/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

class AutocraftingRequestButton
extends AbstractButton {
    private final AutocraftingRequest request;
    private final TextMarquee text;
    private final Consumer<AutocraftingRequest> onPress;

    AutocraftingRequestButton(int x, int y, AutocraftingRequest request, Consumer<AutocraftingRequest> onPress) {
        super(x, y, 64, 24, (Component)Component.empty());
        this.request = request;
        ResourceKey resource = request.getResource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.text = new TextMarquee(rendering.getDisplayName(resource), 36, 0xFFFFFF, true, true);
        this.onPress = onPress;
    }

    AutocraftingRequest getRequest() {
        return this.request;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        this.renderResourceIcon(graphics);
        int yOffset = SmallText.isSmall() ? 8 : 5;
        this.text.render(graphics, this.getX() + 3 + 16 + 3, this.getY() + yOffset, Minecraft.getInstance().font, this.isHovered);
    }

    private void renderResourceIcon(GuiGraphics graphics) {
        long l;
        ResourceKey resource = this.request.getResource();
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        int resourceX = this.getX() + 3;
        int resourceY = this.getY() + 4;
        rendering.render(resource, graphics, resourceX, resourceY);
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            l = platformResource.getResourceType().normalizeAmount(this.request.getAmount());
        } else {
            l = 0L;
        }
        long normalizedAmount = l;
        ResourceSlotRendering.renderAmount(graphics, resourceX, resourceY, normalizedAmount, rendering);
    }

    public void onPress() {
        this.onPress.accept(this.request);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

