/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.Alternative;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativeSlot;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Vector3f;

public class AlternativesScreen
extends AbstractAmountScreen<AlternativeContainerMenu, Double> {
    static final int ALTERNATIVE_ROW_HEIGHT = 18;
    static final int ALTERNATIVE_HEIGHT = 36;
    static final int RESOURCES_PER_ROW = 9;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/alternatives.png");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "configure_amount");
    private static final MutableComponent ALTERNATIVES = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives");
    private static final MutableComponent EXPAND = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives.expand");
    private static final Component SEARCH_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.alternatives.search_help").withStyle(ChatFormatting.GRAY);
    private static final WidgetSprites EXPAND_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/expand"), IdentifierUtil.createIdentifier("widget/expand_disabled"), IdentifierUtil.createIdentifier("widget/expand_focused"), IdentifierUtil.createIdentifier("widget/expand_disabled"));
    private static final WidgetSprites COLLAPSE_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/collapse"), IdentifierUtil.createIdentifier("widget/collapse_focused"));
    private static final int ALTERNATIVES_DISPLAYED = 2;
    private static final int ROWS_PER_ALTERNATIVE = 2;
    private static final int INSET_WIDTH = 164;
    private static final int INSET_HEIGHT = 72;
    private final ResourceSlot slot;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private EditBox searchField;
    private final List<CheckboxWidget> alternativeCheckboxes = new ArrayList<CheckboxWidget>();
    private final List<Button> expandButtons = new ArrayList<Button>();
    private final Set<ResourceLocation> initialAllowedAlternativeIds;

    AlternativesScreen(Screen parent, Inventory playerInventory, Set<ResourceLocation> allowedAlternativeIds, ResourceSlot slot) {
        super(new AlternativeContainerMenu(slot), parent, playerInventory, (Component)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(slot.getDisplayAmount()).withIncrementsTop(1, 10, 64).withIncrementsTopStartPosition(new Vector3f(49.0f, 20.0f, 0.0f)).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(49.0f, 71.0f, 0.0f)).withAmountFieldPosition(new Vector3f(47.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(7.0f, 199.0f, 0.0f)).withHorizontalActionButtons(true).withMinAmount(() -> slot.getResource() != null ? slot.getResource().getResourceType().getDisplayAmount(1L) : 1.0).withMaxAmount(slot.getMaxAmountWhenModifying()).withResetAmount(1.0).build(), DoubleAmountOperations.INSTANCE);
        this.slot = slot;
        this.imageWidth = 193;
        this.imageHeight = 226;
        this.initialAllowedAlternativeIds = allowedAlternativeIds;
    }

    @Override
    protected void init() {
        super.init();
        this.alternativeCheckboxes.clear();
        this.expandButtons.clear();
        int x = this.getInsetX();
        for (int i = 0; i < ((AlternativeContainerMenu)this.getMenu()).getAlternatives().size(); ++i) {
            this.addWidgetsForAlternative(i, x);
        }
        this.scrollbar = new ScrollbarWidget(this.leftPos + 173, this.topPos + 122, ScrollbarWidget.Type.NORMAL, 72);
        int overflowingAlternatives = ((AlternativeContainerMenu)this.getMenu()).getAlternatives().size() - 2;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? overflowingAlternatives * 36 : overflowingAlternatives * 2;
        this.scrollbar.setMaxOffset(maxOffset);
        this.scrollbar.setEnabled(maxOffset > 0);
        this.scrollbar.setListener(value -> this.updateWidgets());
        this.addWidget((GuiEventListener)this.scrollbar);
        Objects.requireNonNull(this.font);
        this.searchField = new EditBox(this.font, this.leftPos + 24, this.topPos + 109, 156, 9, (Component)Component.empty());
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setCanLoseFocus(true);
        this.searchField.setFocused(false);
        this.searchField.setResponder(query -> ((AlternativeContainerMenu)this.getMenu()).filter((String)query));
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.addRenderableWidget((GuiEventListener)new SearchIconWidget(this.leftPos + 7, this.topPos + 107, () -> SEARCH_HELP, this.searchField));
    }

    private int getInsetY() {
        return this.topPos + 122;
    }

    private int getInsetX() {
        return this.leftPos + 8;
    }

    private int getAlternativeY(int idx) {
        return this.getInsetY() + 36 * idx;
    }

    private void addWidgetsForAlternative(int idx, int x) {
        Alternative alternative = ((AlternativeContainerMenu)this.getMenu()).getAlternatives().get(idx);
        int y = this.getAlternativeY(idx);
        boolean hasTranslation = I18n.exists((String)alternative.getTranslationKey());
        MutableComponent id = Component.literal((String)alternative.getId().toString());
        CheckboxWidget alternativeCheckbox = new CheckboxWidget(x + 2, y + 9 - 4, 141, (Component)(hasTranslation ? Component.translatable((String)alternative.getTranslationKey()) : id), this.font, this.initialAllowedAlternativeIds.contains(alternative.getId()), CheckboxWidget.Size.SMALL);
        if (hasTranslation) {
            alternativeCheckbox.setTooltip(Tooltip.create((Component)id));
        }
        this.alternativeCheckboxes.add((CheckboxWidget)this.addWidget((GuiEventListener)alternativeCheckbox));
        CustomButton expandButton = new CustomButton(x + 164 - 16 - 1, y + 1, 16, 16, EXPAND_SPRITES, btn -> {
            boolean expanding = alternative.expandOrCollapse();
            btn.setSprites(expanding ? COLLAPSE_SPRITES : EXPAND_SPRITES);
        }, (Component)EXPAND);
        expandButton.active = alternative.getResources().size() > 9;
        this.expandButtons.add((Button)this.addWidget((GuiEventListener)expandButton));
    }

    protected void containerTick() {
        super.containerTick();
        ((AlternativeContainerMenu)this.getMenu()).getAlternatives().forEach(Alternative::update);
        this.updateWidgets();
    }

    private void updateWidgets() {
        ScrollbarWidget theScrollbar = this.scrollbar;
        if (theScrollbar == null) {
            return;
        }
        double totalHeight = 0.0;
        int totalRows = 0;
        int scrollbarOffset = (int)theScrollbar.getOffset();
        int y = this.getAlternativeY(0) - (theScrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18);
        for (int i = 0; i < ((AlternativeContainerMenu)this.getMenu()).getAlternatives().size(); ++i) {
            Alternative alternative = ((AlternativeContainerMenu)this.getMenu()).getAlternatives().get(i);
            CheckboxWidget alternativeCheckbox = this.alternativeCheckboxes.get(i);
            Button expandButton = this.expandButtons.get(i);
            if (!alternative.isVisible()) {
                alternativeCheckbox.visible = false;
                expandButton.visible = false;
                this.updateAlternativeSlots(alternative.getMainSlots(), y, 0, false);
                this.updateAlternativeSlots(alternative.getOverflowSlots(), y, 1, false);
                continue;
            }
            totalRows += 2;
            int overflowRows = AlternativesScreen.getOverflowRows(alternative);
            totalRows += (int)((double)overflowRows * alternative.getExpandPct());
            int height = 36 + (int)((double)(overflowRows * 18) * alternative.getExpandPct());
            this.updateAlternativeCheckbox(alternativeCheckbox, y);
            this.updateExpandButton(expandButton, y);
            this.updateAlternativeSlots(alternative.getMainSlots(), y, 0, true);
            this.updateAlternativeSlots(alternative.getOverflowSlots(), y, 1, alternative.getExpandPct() > 0.0);
            totalHeight += (double)height;
            y += height;
        }
        double maxOffset = theScrollbar.isSmoothScrolling() ? totalHeight - 72.0 : (double)(totalRows - 4);
        theScrollbar.setMaxOffset(maxOffset);
        theScrollbar.setEnabled(maxOffset > 0.0);
    }

    private void updateAlternativeCheckbox(CheckboxWidget alternativeCheckbox, int y) {
        alternativeCheckbox.setY(y + 9 - 4);
        alternativeCheckbox.visible = alternativeCheckbox.getY() >= this.getInsetY() - alternativeCheckbox.getHeight() && alternativeCheckbox.getY() < this.getInsetY() + 72;
    }

    private void updateExpandButton(Button expandButton, int y) {
        expandButton.setY(y + 1);
        expandButton.visible = expandButton.getY() >= this.getInsetY() - expandButton.getHeight() && expandButton.getY() < this.getInsetY() + 72;
    }

    private void updateAlternativeSlots(List<AlternativeSlot> slots, int y, int rowOffset, boolean visible) {
        for (int i = 0; i < slots.size(); ++i) {
            int row = i / 9 + rowOffset;
            AlternativeSlot resourceSlot = slots.get(i);
            Platform.INSTANCE.setSlotY(resourceSlot, y + 18 + row * 18 + 1 - this.topPos);
            resourceSlot.setActive(resourceSlot.y + this.topPos >= this.getInsetY() - 18 && resourceSlot.y + this.topPos < this.getInsetY() + 72 && visible);
        }
    }

    private static int getOverflowRows(Alternative alternative) {
        return Math.ceilDiv(alternative.getResources().size() - 9, 9);
    }

    @Override
    protected void renderResourceSlots(GuiGraphics graphics) {
        ResourceSlotRendering.render(graphics, ((AlternativeContainerMenu)this.getMenu()).getAmountSlot(), this.leftPos, this.topPos);
    }

    @Override
    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        int insetContentX = this.getInsetX();
        int insetContentY = this.getInsetY();
        return mouseX >= (double)insetContentX && mouseX < (double)(insetContentX + 164) && mouseY >= (double)insetContentY && mouseY < (double)(insetContentY + 72);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        int x = this.getInsetX();
        int y = this.getInsetY();
        graphics.enableScissor(x, y, x + 164, y + 72);
        int currentY = y - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
        for (int i = 0; i < ((AlternativeContainerMenu)this.getMenu()).getAlternatives().size(); ++i) {
            currentY += this.renderAlternativeBackground(graphics, mouseX, mouseY, i, y, x, currentY);
        }
        this.renderAlternativeMainSlots(graphics, mouseX, mouseY);
        this.alternativeCheckboxes.forEach(c -> c.render(graphics, mouseX, mouseY, delta));
        this.expandButtons.forEach(c -> c.render(graphics, mouseX, mouseY, delta));
        graphics.disableScissor();
    }

    private int renderAlternativeBackground(GuiGraphics graphics, int mouseX, int mouseY, int i, int startY, int x, int y) {
        boolean backgroundVisible;
        Alternative alternative = ((AlternativeContainerMenu)this.getMenu()).getAlternatives().get(i);
        if (!alternative.isVisible()) {
            return 0;
        }
        int height = 36 + (int)((double)(AlternativesScreen.getOverflowRows(alternative) * 18) * alternative.getExpandPct());
        boolean bl = backgroundVisible = y >= startY - height && y < startY + 72;
        if (i % 2 == 0 && backgroundVisible) {
            graphics.fill(x, y, x + 164, y + height, 0, -3750202);
        }
        int mainSlotsY = y + 18;
        this.renderMainSlotsBackground(graphics, startY, x, mainSlotsY, alternative);
        int overflowSlotsY = y + 36;
        return 36 + this.renderOverflowSlotsBackground(graphics, mouseX, mouseY, startY, x, overflowSlotsY, alternative);
    }

    private void renderMainSlotsBackground(GuiGraphics graphics, int startY, int x, int y, Alternative alternative) {
        if (y >= startY - 18 && y < startY + 72) {
            for (int col = 0; col < Math.min(alternative.getResources().size(), 9); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.blitSprite(Sprites.SLOT, slotX, y, 18, 18);
            }
        }
    }

    private int renderOverflowSlotsBackground(GuiGraphics graphics, int mouseX, int mouseY, int startY, int x, int y, Alternative alternative) {
        int rows = AlternativesScreen.getOverflowRows(alternative);
        int height = (int)((double)(rows * 18) * alternative.getExpandPct());
        if (height == 0) {
            return 0;
        }
        graphics.enableScissor(x, y, x + 162, y + height);
        for (int row = 0; row < rows; ++row) {
            int idx;
            boolean visible;
            int rowY = y + 18 * row;
            boolean bl = visible = rowY >= startY - 18 && rowY < startY + 72;
            if (!visible) continue;
            for (int col = 0; col < 9 && (idx = 9 + row * 9 + col) < alternative.getResources().size(); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.blitSprite(Sprites.SLOT, slotX, rowY, 18, 18);
            }
        }
        this.renderSlots(alternative.getOverflowSlots(), graphics, mouseX, mouseY);
        graphics.disableScissor();
        return height;
    }

    private void renderAlternativeMainSlots(GuiGraphics graphics, int mouseX, int mouseY) {
        for (Alternative alternative : ((AlternativeContainerMenu)this.getMenu()).getAlternatives()) {
            this.renderSlots(alternative.getMainSlots(), graphics, mouseX, mouseY);
        }
    }

    private void renderSlots(List<AlternativeSlot> slots, GuiGraphics graphics, int mouseX, int mouseY) {
        for (ResourceSlot resourceSlot : slots) {
            if (!resourceSlot.isActive()) continue;
            ResourceSlotRendering.render(graphics, resourceSlot, this.leftPos, this.topPos);
            if (!this.isHovering(resourceSlot.x, resourceSlot.y, 16, 16, mouseX, mouseY) || !this.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY)) continue;
            AlternativesScreen.renderSlotHighlight((GuiGraphics)graphics, (int)(this.leftPos + resourceSlot.x), (int)(this.topPos + resourceSlot.y), (int)0);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, (Component)ALTERNATIVES, 7, 96, 0x404040, false);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        return this.scrollbar != null && this.scrollbar.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didScrollbar = this.isOverAlternativesArea(x, y) && this.scrollbar != null && this.scrollbar.mouseScrolled(x, y, z, delta);
        return didScrollbar || super.mouseScrolled(x, y, z, delta);
    }

    @Override
    public boolean charTyped(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.searchField != null && (this.searchField.keyPressed(key, scanCode, modifiers) || this.searchField.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private boolean isOverAlternativesArea(double x, double y) {
        return x >= (double)(this.leftPos + 7) && x < (double)(this.leftPos + 7 + 179) && y >= (double)(this.topPos + 121) && y < (double)(this.topPos + 121 + 74);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected boolean confirm(Double amount) {
        this.slot.changeAmountOnClient(amount);
        HashSet<Alternative> allowedAlternatives = new HashSet<Alternative>();
        for (int i = 0; i < this.alternativeCheckboxes.size(); ++i) {
            if (!this.alternativeCheckboxes.get(i).isSelected()) continue;
            allowedAlternatives.add(((AlternativeContainerMenu)this.getMenu()).getAlternatives().get(i));
        }
        ((AlternativeContainerMenu)this.getMenu()).sendAllowedAlternatives(allowedAlternatives);
        return true;
    }

    @Override
    protected void reset() {
        super.reset();
        this.alternativeCheckboxes.forEach(c -> c.setSelected(false));
    }
}

