/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.Sprites;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

class ProcessingPatternClientTooltipComponent
implements ClientTooltipComponent {
    private static final long CYCLE_MS = 1000L;
    private static final int ARROW_SPACING = 8;
    private final int rows;
    private final List<Component> outputTexts;
    private final List<List<ResourceAmount>> inputs;
    private final List<List<ResourceAmount>> outputs;
    private long cycleStart = 0L;
    private int currentCycle = 0;

    ProcessingPatternClientTooltipComponent(ProcessingPatternState state) {
        this.rows = ProcessingPatternClientTooltipComponent.calculateMaxRows(state);
        this.outputTexts = ProcessingPatternClientTooltipComponent.getOutputText(state);
        this.inputs = state.ingredients().stream().map(processingIngredient -> processingIngredient.stream().flatMap(i -> i.calculateInputsIncludingAlternatives().stream().map(resource -> new ResourceAmount((ResourceKey)resource, i.input().amount()))).toList()).toList();
        this.outputs = state.outputs().stream().map(output -> output.map(List::of).orElse(List.of())).toList();
    }

    private static int calculateMaxRows(ProcessingPatternState state) {
        int lastFilledInputIndex = 0;
        for (int i = 0; i < state.ingredients().size(); ++i) {
            if (!state.ingredients().get(i).isPresent()) continue;
            lastFilledInputIndex = i;
        }
        int lastFilledOutputIndex = 0;
        for (int i = 0; i < state.outputs().size(); ++i) {
            if (!state.outputs().get(i).isPresent()) continue;
            lastFilledOutputIndex = i;
        }
        int lastFilledInputRow = Math.ceilDiv(lastFilledInputIndex + 1, 3);
        int lastFilledOutputRow = Math.ceilDiv(lastFilledOutputIndex + 1, 3);
        return Math.max(lastFilledInputRow, lastFilledOutputRow);
    }

    private static List<Component> getOutputText(ProcessingPatternState state) {
        return state.getFlatOutputs().stream().map(ProcessingPatternClientTooltipComponent::getOutputText).toList();
    }

    private static Component getOutputText(ResourceAmount resourceAmount) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resourceAmount.resource().getClass());
        String displayAmount = rendering.formatAmount(resourceAmount.amount());
        return Component.literal((String)String.format("%sx ", displayAmount)).append(rendering.getDisplayName(resourceAmount.resource())).withStyle(ChatFormatting.GRAY);
    }

    public int getHeight() {
        return this.outputTexts.size() * 9 + 2 + this.rows * 18 + 3;
    }

    public int getWidth(Font font) {
        return Math.max(this.outputTexts.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0), 146);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        long now = System.currentTimeMillis();
        if (this.cycleStart == 0L) {
            this.cycleStart = now;
        }
        if (now - this.cycleStart >= 1000L) {
            ++this.currentCycle;
            this.cycleStart = now;
        }
        this.renderOutputText(font, x, y, graphics);
        int matrixSlotsY = y + this.outputTexts.size() * 9 + 2;
        this.renderMatrixSlots(x, matrixSlotsY, true, graphics);
        graphics.blitSprite(Sprites.LIGHT_ARROW, x + 54 + 8, y + this.outputTexts.size() * 9 + 2 + this.rows * 18 / 2 - 7, 22, 15);
        this.renderMatrixSlots(x, matrixSlotsY, false, graphics);
    }

    private void renderMatrixSlots(int x, int y, boolean input, GuiGraphics graphics) {
        int maxSize = input ? this.inputs.size() : this.outputs.size();
        block0: for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < 3; ++column) {
                int slotXOffset = !input ? 92 : 0;
                int slotX = x + slotXOffset + column * 18;
                int slotY = y + row * 18;
                int idx = row * 3 + column;
                if (idx >= maxSize) continue block0;
                if (input) {
                    this.renderMatrixSlot(graphics, slotX, slotY, this.inputs.get(idx));
                    continue;
                }
                this.renderMatrixSlot(graphics, slotX, slotY, this.outputs.get(idx));
            }
        }
    }

    private void renderMatrixSlot(GuiGraphics graphics, int slotX, int slotY, List<ResourceAmount> possibilities) {
        graphics.blitSprite(Sprites.SLOT, slotX, slotY, 18, 18);
        if (possibilities.isEmpty()) {
            return;
        }
        ResourceAmount resourceAmount = possibilities.get(this.currentCycle % possibilities.size());
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resourceAmount.resource().getClass());
        rendering.render(resourceAmount.resource(), graphics, slotX + 1, slotY + 1);
        ResourceSlotRendering.renderAmount(graphics, slotX + 1, slotY + 1, resourceAmount.amount(), rendering);
    }

    private void renderOutputText(Font font, int x, int y, GuiGraphics graphics) {
        for (int i = 0; i < this.outputTexts.size(); ++i) {
            graphics.drawString(font, this.outputTexts.get(i), x, y + i * 9, 0xAAAAAA);
        }
    }
}

