/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.root;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.listenable.ListenableResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeStorageImpl;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public class RootStorageImpl
implements RootStorage {
    protected final CompositeStorageImpl storage;
    private final ListenableResourceList list;
    private final Set<RootStorageListener> listeners;

    public RootStorageImpl() {
        this(MutableResourceListImpl.create(), new HashSet<RootStorageListener>());
    }

    public RootStorageImpl(MutableResourceList list) {
        this(list, new HashSet<RootStorageListener>());
    }

    public RootStorageImpl(MutableResourceList list, Set<RootStorageListener> listeners) {
        this.list = new ListenableResourceList(list);
        this.storage = new CompositeStorageImpl(this.list);
        this.listeners = listeners;
    }

    @Override
    public void sortSources() {
        this.storage.sortSources();
    }

    @Override
    public void addSource(Storage source) {
        this.storage.addSource(source);
    }

    @Override
    public void removeSource(Storage source) {
        this.storage.removeSource(source);
    }

    @Override
    public boolean hasSource(Predicate<Storage> matcher) {
        return this.storage.getSources().stream().anyMatch(matcher);
    }

    @Override
    public void addListener(RootStorageListener listener) {
        this.list.addListener(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RootStorageListener listener) {
        this.list.removeListener(listener);
        this.listeners.remove(listener);
    }

    @Override
    public long get(ResourceKey resource) {
        return this.list.get(resource);
    }

    @Override
    public boolean contains(ResourceKey resource) {
        return this.list.contains(resource);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.storage.extract(resource, amount, action, actor);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        long inserted;
        long totalIntercepted = 0L;
        if (action == Action.EXECUTE) {
            for (RootStorageListener listener : this.listeners) {
                long available;
                long intercepted = listener.beforeInsert(resource, available = amount - totalIntercepted);
                if (intercepted > available || intercepted < 0L) {
                    throw new IllegalStateException("Intercepted %d while %d was available".formatted(intercepted, available));
                }
                if ((totalIntercepted += intercepted) != amount) continue;
                return totalIntercepted;
            }
        }
        if ((inserted = this.storage.insert(resource, amount - totalIntercepted, action, actor)) > 0L && action == Action.EXECUTE) {
            this.notifyAfterInsertListeners(resource, inserted);
        }
        return inserted + totalIntercepted;
    }

    private void notifyAfterInsertListeners(ResourceKey resource, long inserted) {
        long available = inserted;
        for (RootStorageListener listener : this.listeners) {
            long reserved = listener.afterInsert(resource, available);
            if (reserved > available || reserved < 0L) {
                throw new IllegalStateException("Reserved %d while %d was available".formatted(reserved, available));
            }
            if ((available -= reserved) != 0L) continue;
            return;
        }
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        return this.storage.getAll();
    }

    @Override
    public long getStored() {
        return this.storage.getStored();
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        return this.storage.findTrackedResourceByActorType(resource, actorType);
    }
}

