/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.composite;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageView;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeAwareChild;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeStorage;
import com.refinedmods.refinedstorage.api.storage.composite.ParentComposite;
import com.refinedmods.refinedstorage.api.storage.composite.PrioritizedStorageComparator;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public class CompositeStorageImpl
implements CompositeStorage,
CompositeAwareChild,
ParentComposite {
    private final List<Storage> insertSources = new ArrayList<Storage>();
    private final List<Storage> extractSources = new ArrayList<Storage>();
    private final MutableResourceList list;
    private final Set<ParentComposite> parentComposites = new HashSet<ParentComposite>();

    public CompositeStorageImpl(MutableResourceList list) {
        this.list = list;
    }

    @Override
    public void sortSources() {
        this.insertSources.sort(PrioritizedStorageComparator.INSERT);
        this.extractSources.sort(PrioritizedStorageComparator.EXTRACT);
    }

    @Override
    public void addSource(Storage source) {
        this.insertSources.add(source);
        this.extractSources.add(source);
        this.sortSources();
        this.addContentOfSourceToList(source);
        this.parentComposites.forEach(parentComposite -> parentComposite.onSourceAddedToChild(source));
        if (source instanceof CompositeAwareChild) {
            CompositeAwareChild compositeAwareChild = (CompositeAwareChild)source;
            compositeAwareChild.onAddedIntoComposite(this);
        }
    }

    @Override
    public void removeSource(Storage source) {
        this.insertSources.remove(source);
        this.extractSources.remove(source);
        this.removeContentOfSourceFromList(source);
        this.parentComposites.forEach(parentComposite -> parentComposite.onSourceRemovedFromChild(source));
        if (source instanceof CompositeAwareChild) {
            CompositeAwareChild compositeAwareChild = (CompositeAwareChild)source;
            compositeAwareChild.onRemovedFromComposite(this);
        }
    }

    @Override
    public List<Storage> getSources() {
        return Collections.unmodifiableList(this.insertSources);
    }

    @Override
    public void clearSources() {
        HashSet<Storage> oldSources = new HashSet<Storage>(this.insertSources);
        oldSources.forEach(this::removeSource);
    }

    @Override
    public boolean contains(Storage storage) {
        for (Storage source : this.insertSources) {
            CompositeAwareChild compositeAwareChild;
            if (!(source instanceof CompositeAwareChild) || !(compositeAwareChild = (CompositeAwareChild)source).contains(storage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        ResourceAmount.validate(resource, amount);
        long remaining = amount;
        long toRemoveFromList = 0L;
        for (Storage source : this.extractSources) {
            if (source instanceof CompositeAwareChild) {
                CompositeAwareChild compositeAwareChild = (CompositeAwareChild)source;
                CompositeAwareChild.Amount extracted = compositeAwareChild.compositeExtract(resource, remaining, action, actor);
                remaining -= extracted.amount();
                toRemoveFromList += extracted.amountForList();
            } else {
                long extracted = source.extract(resource, remaining, action, actor);
                remaining -= extracted;
                toRemoveFromList += extracted;
            }
            if (remaining != 0L) continue;
            break;
        }
        long extracted = amount - remaining;
        if (action == Action.EXECUTE && toRemoveFromList > 0L) {
            this.list.remove(resource, toRemoveFromList);
        }
        return extracted;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        ResourceAmount.validate(resource, amount);
        long inserted = 0L;
        long toInsertIntoList = 0L;
        for (Storage source : this.insertSources) {
            if (source instanceof CompositeAwareChild) {
                CompositeAwareChild compositeAwareChild = (CompositeAwareChild)source;
                CompositeAwareChild.Amount insertedAmount = compositeAwareChild.compositeInsert(resource, amount - inserted, action, actor);
                inserted += insertedAmount.amount();
                toInsertIntoList += insertedAmount.amountForList();
            } else {
                long insertedAmount = source.insert(resource, amount - inserted, action, actor);
                inserted += insertedAmount;
                toInsertIntoList += insertedAmount;
            }
            if (inserted != amount) continue;
            break;
        }
        if (action == Action.EXECUTE && toInsertIntoList > 0L) {
            this.list.add(resource, toInsertIntoList);
        }
        return inserted;
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        return this.list.copyState();
    }

    @Override
    public long getStored() {
        return this.insertSources.stream().mapToLong(StorageView::getStored).sum();
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        return this.insertSources.stream().filter(TrackedStorage.class::isInstance).map(TrackedStorage.class::cast).flatMap(storage -> storage.findTrackedResourceByActorType(resource, actorType).stream()).max(Comparator.comparingLong(TrackedResource::getTime));
    }

    @Override
    public void onAddedIntoComposite(ParentComposite parentComposite) {
        this.parentComposites.add(parentComposite);
    }

    @Override
    public void onRemovedFromComposite(ParentComposite parentComposite) {
        this.parentComposites.remove(parentComposite);
    }

    @Override
    public CompositeAwareChild.Amount compositeInsert(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeAwareChild.Amount compositeExtract(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onSourceAddedToChild(Storage source) {
        this.addContentOfSourceToList(source);
    }

    @Override
    public void onSourceRemovedFromChild(Storage source) {
        this.removeContentOfSourceFromList(source);
    }

    @Override
    public void addToCache(ResourceKey resource, long amount) {
        this.list.add(resource, amount);
    }

    @Override
    public void removeFromCache(ResourceKey resource, long amount) {
        this.list.remove(resource, amount);
    }

    private void addContentOfSourceToList(Storage source) {
        source.getAll().forEach(this.list::add);
    }

    private void removeContentOfSourceFromList(Storage source) {
        source.getAll().forEach(resourceAmount -> this.list.remove(resourceAmount.resource(), resourceAmount.amount()));
    }
}

