/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.list;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-beta.11")
public class LazyCopyMutableResourceList
implements MutableResourceList {
    private final MutableResourceList original;
    private final MutableResourceList updates;
    private final Set<ResourceKey> pulled;

    private LazyCopyMutableResourceList(MutableResourceList original, MutableResourceList updates, Set<ResourceKey> pulled) {
        this.original = original;
        this.updates = updates;
        this.pulled = pulled;
    }

    public static LazyCopyMutableResourceList create(MutableResourceList original) {
        return new LazyCopyMutableResourceList(original, MutableResourceListImpl.create(), new HashSet<ResourceKey>());
    }

    @Override
    public MutableResourceList.OperationResult add(ResourceKey resource, long amount) {
        ResourceAmount.validate(resource, amount);
        this.pullIntoUpdates(resource);
        return this.updates.add(resource, amount);
    }

    private void pullIntoUpdates(ResourceKey resource) {
        if (!this.pulled.add(resource)) {
            return;
        }
        long amount = this.original.get(resource);
        if (amount > 0L) {
            this.updates.add(resource, amount);
        }
    }

    @Override
    @Nullable
    public MutableResourceList.OperationResult remove(ResourceKey resource, long amount) {
        ResourceAmount.validate(resource, amount);
        this.pullIntoUpdates(resource);
        return this.updates.remove(resource, amount);
    }

    @Override
    public void clear() {
        this.pulled.addAll(this.original.getAll());
        this.updates.clear();
    }

    @Override
    public MutableResourceList copy() {
        return new LazyCopyMutableResourceList(this.original, this.updates.copy(), new HashSet<ResourceKey>(this.pulled));
    }

    @Override
    public Collection<ResourceAmount> copyState() {
        HashSet<ResourceAmount> copy = new HashSet<ResourceAmount>(this.original.copyState());
        copy.removeIf(ra -> this.pulled.contains(ra.resource()));
        copy.addAll(this.updates.copyState());
        return Collections.unmodifiableSet(copy);
    }

    @Override
    public Set<ResourceKey> getAll() {
        HashSet<ResourceKey> all = new HashSet<ResourceKey>(this.original.getAll());
        all.removeAll(this.pulled);
        all.addAll(this.updates.getAll());
        return Collections.unmodifiableSet(all);
    }

    @Override
    public long get(ResourceKey resource) {
        if (this.pulled.contains(resource)) {
            return this.updates.get(resource);
        }
        return this.original.get(resource);
    }

    @Override
    public boolean contains(ResourceKey resource) {
        if (this.pulled.contains(resource)) {
            return this.updates.contains(resource);
        }
        return this.original.contains(resource);
    }

    @Override
    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    public String toString() {
        return String.valueOf(this.original) + " -> " + String.valueOf(this.updates);
    }
}

