/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepositoryImpl;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorImpl;
import com.refinedmods.refinedstorage.api.autocrafting.craftability.IsCraftableCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreviewCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlanCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternListener;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocraftingNetworkComponentImpl
implements AutocraftingNetworkComponent,
ParentContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocraftingNetworkComponentImpl.class);
    private final Supplier<RootStorage> rootStorageProvider;
    private final ExecutorService executorService;
    private final Set<PatternProvider> providers = new HashSet<PatternProvider>();
    private final Map<Pattern, PatternProvider> providerByPattern = new HashMap<Pattern, PatternProvider>();
    private final Map<PatternLayout, List<ExternalPatternSink>> sinksByPatternLayout = new HashMap<PatternLayout, List<ExternalPatternSink>>();
    private final Map<TaskId, PatternProvider> providerByTaskId = new HashMap<TaskId, PatternProvider>();
    private final Set<PatternListener> patternListeners = new HashSet<PatternListener>();
    private final Set<TaskStatusListener> statusListeners = new HashSet<TaskStatusListener>();
    private final PatternRepositoryImpl patternRepository = new PatternRepositoryImpl();

    public AutocraftingNetworkComponentImpl(Supplier<RootStorage> rootStorageProvider, ExecutorService executorService) {
        this.rootStorageProvider = rootStorageProvider;
        this.executorService = executorService;
    }

    @Override
    public void onContainerAdded(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof PatternProvider) {
            PatternProvider provider = (PatternProvider)((Object)networkNode);
            provider.onAddedIntoContainer(this);
            this.providers.add(provider);
        }
    }

    @Override
    public void onContainerRemoved(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof PatternProvider) {
            PatternProvider provider = (PatternProvider)((Object)networkNode);
            provider.onRemovedFromContainer(this);
            this.providers.remove(provider);
        }
    }

    @Override
    public Set<ResourceKey> getOutputs() {
        return this.patternRepository.getOutputs();
    }

    @Override
    public boolean contains(AutocraftingNetworkComponent component) {
        return this.providers.stream().anyMatch(provider -> provider.contains(component));
    }

    @Override
    @Nullable
    public PatternProvider getProviderByPattern(Pattern pattern) {
        return this.providerByPattern.get(pattern);
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        ResourceAmount.validate(resource, amount);
        try {
            return CompletableFuture.supplyAsync(() -> {
                RootStorage rootStorage = this.rootStorageProvider.get();
                CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(this.patternRepository, rootStorage);
                Preview preview = PreviewCraftingCalculatorListener.calculatePreview(calculator, resource, amount, cancellationToken);
                return Optional.of(preview);
            }, this.executorService);
        }
        catch (RejectedExecutionException e) {
            return CompletableFuture.completedFuture(Optional.of(new Preview(PreviewType.NOT_AVAILABLE, Collections.emptyList(), Collections.emptyList())));
        }
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        ResourceAmount.validate(resource, amount);
        try {
            return CompletableFuture.supplyAsync(() -> {
                RootStorage rootStorage = this.rootStorageProvider.get();
                CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(this.patternRepository, rootStorage);
                TreePreview tree = TreePreviewCraftingCalculatorListener.calculateTree(calculator, resource, amount, cancellationToken);
                return Optional.of(tree);
            }, this.executorService);
        }
        catch (RejectedExecutionException e) {
            return CompletableFuture.completedFuture(Optional.of(new TreePreview(PreviewType.NOT_AVAILABLE, null, Collections.emptyList())));
        }
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        CoreValidations.validateNotNull(resource, "Resource cannot be null");
        RootStorage rootStorage = this.rootStorageProvider.get();
        CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(this.patternRepository, rootStorage);
        return CompletableFuture.supplyAsync(() -> IsCraftableCraftingCalculatorListener.binarySearchMaxAmount(calculator, resource, cancellationToken), this.executorService);
    }

    @Override
    public Optional<TaskId> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        ResourceAmount.validate(resource, amount);
        RootStorage rootStorage = this.rootStorageProvider.get();
        CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(this.patternRepository, rootStorage);
        return TaskPlanCraftingCalculatorListener.calculatePlan(calculator, resource, amount, cancellationToken).map(plan -> this.addTask(resource, amount, actor, (TaskPlan)plan, notify));
    }

    @Override
    public AutocraftingNetworkComponent.EnsureResult ensureTask(ResourceKey resource, long amount, Actor actor, CancellationToken cancellationToken) {
        ResourceAmount.validate(resource, amount);
        long currentlyCrafting = this.providers.stream().mapToLong(provider -> provider.getAmount(resource)).sum();
        if (currentlyCrafting >= amount) {
            return AutocraftingNetworkComponent.EnsureResult.TASK_ALREADY_RUNNING;
        }
        RootStorage rootStorage = this.rootStorageProvider.get();
        long correctedAmount = amount - currentlyCrafting;
        CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(this.patternRepository, rootStorage);
        return TaskPlanCraftingCalculatorListener.calculatePlan(calculator, resource, correctedAmount, cancellationToken).map(plan -> this.addTask(resource, correctedAmount, actor, (TaskPlan)plan, false)).map(taskId -> AutocraftingNetworkComponent.EnsureResult.TASK_CREATED).orElseGet(() -> this.ensureTaskForCraftableAmount(resource, actor, correctedAmount, calculator, cancellationToken));
    }

    private AutocraftingNetworkComponent.EnsureResult ensureTaskForCraftableAmount(ResourceKey resource, Actor actor, long amount, CraftingCalculator calculator, CancellationToken cancellationToken) {
        long correctedAmount = Math.min(IsCraftableCraftingCalculatorListener.binarySearchMaxAmount(calculator, resource, CancellationToken.NONE), amount);
        if (correctedAmount <= 0L) {
            return AutocraftingNetworkComponent.EnsureResult.MISSING_RESOURCES;
        }
        return TaskPlanCraftingCalculatorListener.calculatePlan(calculator, resource, correctedAmount, cancellationToken).map(plan -> this.addTask(resource, correctedAmount, actor, (TaskPlan)plan, false)).map(taskId -> AutocraftingNetworkComponent.EnsureResult.TASK_CREATED).orElse(AutocraftingNetworkComponent.EnsureResult.MISSING_RESOURCES);
    }

    private TaskId addTask(ResourceKey resource, long amount, Actor actor, TaskPlan plan, boolean notify) {
        TaskImpl task = new TaskImpl(plan, actor, notify);
        LOGGER.debug("Created task {} for {}x {} for {}", new Object[]{task.getId(), amount, resource, actor});
        PatternProvider provider = CoreValidations.validateNotNull(this.providerByPattern.get(plan.rootPattern()), "No provider for pattern " + String.valueOf(plan.rootPattern()));
        provider.addTask(task);
        return task.getId();
    }

    @Override
    public void addListener(PatternListener listener) {
        this.patternListeners.add(listener);
    }

    @Override
    public void addListener(TaskStatusListener listener) {
        this.statusListeners.add(listener);
    }

    @Override
    public void removeListener(PatternListener listener) {
        this.patternListeners.remove(listener);
    }

    @Override
    public void removeListener(TaskStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    @Override
    public Set<Pattern> getPatterns() {
        return this.patternRepository.getAll();
    }

    @Override
    public List<Pattern> getPatternsByOutput(ResourceKey output) {
        return this.patternRepository.getByOutput(output);
    }

    @Override
    public List<TaskStatus> getStatuses() {
        return this.providers.stream().map(PatternProvider::getTaskStatuses).flatMap(Collection::stream).toList();
    }

    @Override
    public void cancel(TaskId taskId) {
        PatternProvider provider = this.providerByTaskId.get(taskId);
        if (provider == null) {
            return;
        }
        provider.cancelTask(taskId);
    }

    @Override
    public void cancelAll() {
        for (Map.Entry<TaskId, PatternProvider> entry : this.providerByTaskId.entrySet()) {
            PatternProvider provider = entry.getValue();
            TaskId taskId = entry.getKey();
            provider.cancelTask(taskId);
        }
    }

    @Override
    public void add(PatternProvider provider, Pattern pattern, int priority) {
        this.patternRepository.add(pattern, priority);
        this.providerByPattern.put(pattern, provider);
        List sinks = this.sinksByPatternLayout.computeIfAbsent(pattern.layout(), layout -> new ArrayList());
        if (!sinks.contains(provider)) {
            sinks.add(provider);
        }
        this.patternListeners.forEach(listener -> listener.onAdded(pattern));
    }

    @Override
    public void remove(PatternProvider provider, Pattern pattern) {
        this.patternListeners.forEach(listener -> listener.onRemoved(pattern));
        this.providerByPattern.remove(pattern);
        List<ExternalPatternSink> sinksByLayout = this.sinksByPatternLayout.get(pattern.layout());
        if (sinksByLayout != null) {
            sinksByLayout.remove(provider);
            if (sinksByLayout.isEmpty()) {
                this.sinksByPatternLayout.remove(pattern.layout());
            }
        }
        this.patternRepository.remove(pattern);
    }

    @Override
    public void update(Pattern pattern, int priority) {
        this.patternRepository.update(pattern, priority);
    }

    @Override
    public void taskAdded(PatternProvider provider, Task task) {
        this.providerByTaskId.put(task.getId(), provider);
        this.statusListeners.forEach(listener -> listener.taskAdded(task.getStatus()));
    }

    @Override
    public void taskRemoved(Task task) {
        this.providerByTaskId.remove(task.getId());
        this.statusListeners.forEach(listener -> listener.taskRemoved(task.getId()));
    }

    @Override
    public void taskCompleted(Task task) {
        this.taskRemoved(task);
    }

    @Override
    public void taskChanged(Task task) {
        if (this.statusListeners.isEmpty()) {
            return;
        }
        TaskStatus status = task.getStatus();
        this.statusListeners.forEach(listener -> listener.taskStatusChanged(status));
    }

    @Override
    public List<ExternalPatternSink> getSinksByPatternLayout(PatternLayout patternLayout) {
        return this.sinksByPatternLayout.getOrDefault(patternLayout, Collections.emptyList());
    }
}

