/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.MutableTaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Optional;

public class TaskPlanCraftingCalculatorListener
implements CraftingCalculatorListener<MutableTaskPlan> {
    private MutableTaskPlan task;

    private TaskPlanCraftingCalculatorListener(MutableTaskPlan task) {
        this.task = task;
    }

    private TaskPlanCraftingCalculatorListener() {
        this(new MutableTaskPlan());
    }

    public static Optional<TaskPlan> calculatePlan(CraftingCalculator calculator, ResourceKey resource, long amount, CancellationToken cancellationToken) {
        TaskPlanCraftingCalculatorListener listener = new TaskPlanCraftingCalculatorListener();
        try {
            calculator.calculate(resource, amount, listener, cancellationToken);
        }
        catch (CalculationException | CancellationException e) {
            return Optional.empty();
        }
        return listener.task.getPlan();
    }

    @Override
    public CraftingCalculatorListener<MutableTaskPlan> childCalculationStarted(Pattern childPattern, ResourceKey resource, Amount amount) {
        MutableTaskPlan copy = this.task.copy(childPattern, resource, amount.getTotal());
        copy.addOrUpdatePattern(childPattern, amount.iterations());
        return new TaskPlanCraftingCalculatorListener(copy);
    }

    @Override
    public void childCalculationCompleted(CraftingCalculatorListener<MutableTaskPlan> childListener) {
        this.task = childListener.getData();
    }

    @Override
    public void ingredientsExhausted(ResourceKey resource, long amount) {
        this.task.setMissing();
    }

    @Override
    public void ingredientUsed(Pattern ingredientPattern, int ingredientIndex, ResourceKey resource, long amount) {
        this.task.addUsedIngredient(ingredientPattern, ingredientIndex, resource, amount);
    }

    @Override
    public void ingredientExtractedFromStorage(ResourceKey resource, long amount) {
        this.task.addToExtract(resource, amount);
    }

    @Override
    public MutableTaskPlan getData() {
        return this.task;
    }

    @Override
    public boolean requiresFullMissingResourcesCalculation() {
        return false;
    }
}

