/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.PatternCycleDetectedException;
import com.refinedmods.refinedstorage.api.autocrafting.preview.MutableTreePreviewNode;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public class TreePreviewCraftingCalculatorListener
implements CraftingCalculatorListener<MutableTreePreviewNode> {
    @Nullable
    private MutableTreePreviewNode currentNode;

    private TreePreviewCraftingCalculatorListener(@Nullable MutableTreePreviewNode currentNode) {
        this.currentNode = currentNode;
    }

    public static TreePreview calculateTree(CraftingCalculator calculator, ResourceKey resource, long amount, CancellationToken cancellationToken) {
        TreePreviewCraftingCalculatorListener listener = new TreePreviewCraftingCalculatorListener(null);
        try {
            calculator.calculate(resource, amount, listener, cancellationToken);
        }
        catch (PatternCycleDetectedException e) {
            return new TreePreview(PreviewType.CYCLE_DETECTED, null, e.getPattern().layout().outputs());
        }
        catch (NumberOverflowDuringCalculationException e) {
            return new TreePreview(PreviewType.OVERFLOW, null, Collections.emptyList());
        }
        catch (CancellationException e) {
            return new TreePreview(PreviewType.CANCELLED, null, Collections.emptyList());
        }
        return listener.buildPreview();
    }

    @Override
    public void rootCalculationStarted(ResourceKey resource, long amount) {
        this.currentNode = new MutableTreePreviewNode(resource);
        this.currentNode.add(amount);
        this.currentNode.toCraft(amount);
    }

    @Override
    public CraftingCalculatorListener<MutableTreePreviewNode> childCalculationStarted(Pattern childPattern, ResourceKey resource, Amount amount) {
        MutableTreePreviewNode childNode = new MutableTreePreviewNode(resource);
        childNode.toCraft(amount.getTotal());
        return new TreePreviewCraftingCalculatorListener(childNode);
    }

    @Override
    public void childCalculationCompleted(CraftingCalculatorListener<MutableTreePreviewNode> childListener) {
        if (this.currentNode == null) {
            this.currentNode = Objects.requireNonNull(childListener.getData());
            return;
        }
        this.currentNode.merge(childListener.getData());
    }

    @Override
    public void ingredientUsed(Pattern ingredientPattern, int ingredientIndex, ResourceKey resource, long amount) {
        Objects.requireNonNull(this.currentNode).add(resource, amount);
    }

    @Override
    public void ingredientsExhausted(ResourceKey resource, long amount) {
        Objects.requireNonNull(this.currentNode).add(resource).missing(amount);
    }

    @Override
    public void ingredientExtractedFromStorage(ResourceKey resource, long amount) {
        Objects.requireNonNull(this.currentNode).add(resource).available(amount);
    }

    @Override
    public MutableTreePreviewNode getData() {
        return Objects.requireNonNull(this.currentNode);
    }

    public TreePreview buildPreview() {
        return Objects.requireNonNull(this.currentNode).asRootInPreview();
    }
}

