/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SakuraFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<SakuraFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> SakuraFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)placer).and(placer.group((App)IntProvider.codec((int)4, (int)16).fieldOf("height").forGetter(height -> height.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("flower_decoration_chance").forGetter(flowerChance -> Float.valueOf(flowerChance.flowerDecorationChance)))).apply((Applicative)placer, SakuraFoliagePlacer::new));
    public static FoliagePlacerType<?> SAKURA_FOLIAGE_PLACER = new FoliagePlacerType(CODEC);
    private final IntProvider height;
    private final float flowerDecorationChance;

    protected FoliagePlacerType<?> type() {
        return SAKURA_FOLIAGE_PLACER;
    }

    public SakuraFoliagePlacer(IntProvider ip1, IntProvider ip2, IntProvider height, float flowerDecorationChance) {
        super(ip1, ip2);
        this.height = height;
        this.flowerDecorationChance = flowerDecorationChance;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfig, int p_272975_, FoliagePlacer.FoliageAttachment foliage, int p_273647_, int p_273700_, int height) {
        BlockPos blockpos = foliage.pos().above(height);
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlobLeft(level, setter, random, treeConfig, blockpos);
        } else {
            this.placeLeavesBlobRight(level, setter, random, treeConfig, blockpos);
        }
    }

    public boolean placeLeavesBlobLeft(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        this.placeLeavesTopLeft(level, setter, random, treeConfiguration, pos);
        this.placeLeavesMiddle(level, setter, random, treeConfiguration, pos.above());
        this.placeLeavesTopLeft(level, setter, random, treeConfiguration, pos.above().above());
        return true;
    }

    public boolean placeLeavesBlobRight(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        this.placeLeavesTopRight(level, setter, random, treeConfiguration, pos);
        this.placeLeavesMiddle(level, setter, random, treeConfiguration, pos.above());
        this.placeLeavesTopRight(level, setter, random, treeConfiguration, pos.above().above());
        return true;
    }

    public void placeLeavesMiddle(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().east().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().west().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().north());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().north().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().north().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().east().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().west().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().south());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().south().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().south().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.east().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.west().west());
    }

    public void placeLeavesTopLeft(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north().west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south().east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.east().north());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.west());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.west().south());
    }

    public void placeLeavesTopRight(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.north());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.south());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.east());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.west());
    }

    public int foliageHeight(RandomSource p_273679_, int p_273336_, TreeConfiguration p_273643_) {
        return this.height.sample(p_273679_);
    }

    protected boolean shouldSkipLocation(RandomSource p_273294_, int p_273380_, int p_272865_, int p_272853_, int p_272631_, boolean p_273432_) {
        return false;
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = treeConfiguration.foliageProvider.getState(random, pos);
        if (blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, p_225638_ -> p_225638_.isSourceOfType((Fluid)Fluids.WATER))));
        }
        setter.set(pos, blockstate);
        return true;
    }
}

