/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.mixin.common.template.mansion;

import com.google.common.collect.Lists;
import dev.worldgen.lithostitched.config.ConfigHandler;
import dev.worldgen.lithostitched.duck.RegistryHolder;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionPieces;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WoodlandMansionStructure.class})
public class WoodlandMansionStructureMixin {
    @Inject(method={"generatePieces"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRegistriesForTemplateList(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos pos, Rotation rotation, CallbackInfo ci) {
        if (ConfigHandler.getConfig().breaksSeedParity()) {
            LinkedList list = Lists.newLinkedList();
            WoodlandMansionPieces.MansionGrid grid = new WoodlandMansionPieces.MansionGrid((RandomSource)context.random());
            WoodlandMansionPieces.MansionPiecePlacer placer = new WoodlandMansionPieces.MansionPiecePlacer(context.structureTemplateManager(), (RandomSource)context.random());
            ((RegistryHolder)placer).setRegistries(context.registryAccess());
            placer.createMansion(pos, rotation, (List)list, grid);
            list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
            ci.cancel();
        }
    }
}

