/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.config;

import it.crystalnest.cobweb.api.config.CobwebConfig;
import it.crystalnest.cobweb.api.config.ConfigType;
import it.crystalnest.cobweb.platform.Services;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class CommonConfig
extends CobwebConfig {
    protected CommonConfig(ModConfigSpec.Builder builder) {
        super(builder);
    }

    protected static <T extends CommonConfig> T register(String modId, Function<ModConfigSpec.Builder, T> constructor) {
        CommonConfig.register(modId, ConfigType.COMMON, constructor);
        if (Services.CONFIG == null) {
            throw new NullPointerException("Make sure you are on NeoForge or the mod Forge Config API Port is installed!");
        }
        Services.CONFIG.registerCommonConfig(modId, CommonConfig.getSpec(modId));
        return CommonConfig.getConfig(modId);
    }

    @Nullable
    protected static <T extends CommonConfig> T getConfig(String modId) {
        return (T)((CommonConfig)CommonConfig.getConfig(modId, ConfigType.COMMON));
    }

    @Nullable
    protected static ModConfigSpec getSpec(String modId) {
        return CommonConfig.getSpec(modId, ConfigType.COMMON);
    }
}

