/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class ManagedFloat
extends AbstractManagedData<Float> {
    private float value;
    protected Function<Float, Float> validator = null;

    public ManagedFloat(String name, float defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedFloat(String name, DataFlags ... flags) {
        this(name, 0.0f, flags);
    }

    public float set(float value) {
        if (!Objects.equals(Float.valueOf(this.value), Float.valueOf(value))) {
            boolean set = true;
            float prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(Float.valueOf(value));
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public float get() {
        return this.value;
    }

    public ManagedFloat setValidator(Function<Float, Float> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(Float.valueOf(this.value)).floatValue();
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeFloat(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readFloat();
        this.notifyListeners(Float.valueOf(this.value));
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        compound.putFloat(this.name, this.value);
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        this.value = compound.getFloat(this.name);
        this.notifyListeners(Float.valueOf(this.value));
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public float add(float add) {
        return this.set(this.get() + add);
    }

    public float subtract(float subtract) {
        return this.set(this.get() - subtract);
    }

    public float multiply(float multiplyBy) {
        return this.set(this.get() * multiplyBy);
    }

    public float divide(float divideBy) {
        return this.set(this.get() / divideBy);
    }

    public float zero() {
        return this.set(0.0f);
    }

    public float inc() {
        return this.add(1.0f);
    }

    public float dec() {
        return this.subtract(1.0f);
    }
}

