/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.StreamCodec;

public class IntParticleData
implements ParticleOptions {
    private final ParticleType<IntParticleData> type;
    private final List<Integer> data;
    private static final StreamCodec<ByteBuf, List<Integer>> INT_LIST = new StreamCodec<ByteBuf, List<Integer>>(){

        public List<Integer> decode(ByteBuf buf) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                result.add(buf.readInt());
            }
            return result;
        }

        public void encode(ByteBuf buf, List<Integer> list) {
            buf.writeInt(list.size());
            list.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
        }
    };

    public static MapCodec<IntParticleData> codec(ParticleType<IntParticleData> type) {
        return Codec.INT.listOf().xmap(intList -> new IntParticleData(type, (List<Integer>)intList), data -> data.data).fieldOf("data");
    }

    public static StreamCodec<? super ByteBuf, IntParticleData> streamCodec(ParticleType<IntParticleData> type) {
        return INT_LIST.map(ints -> new IntParticleData(type, (List<Integer>)ints), data -> data.data);
    }

    public IntParticleData(ParticleType<IntParticleData> type, Integer ... data) {
        this.type = type;
        this.data = List.of(data);
    }

    public IntParticleData(ParticleType<IntParticleData> type, List<Integer> data) {
        this.type = type;
        this.data = data;
    }

    public ParticleType<IntParticleData> getType() {
        return this.type;
    }

    public List<Integer> get() {
        return this.data;
    }
}

