/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.client.render.BlockEntityRendererTransparent;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public class BCClientEventHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static int remountTicksRemaining = 0;
    private static int remountEntityID = 0;
    private static int debugTimeout = 0;
    private static Map<ResourceKey<Level>, Integer[]> dimTickTimes = new HashMap<ResourceKey<Level>, Integer[]>();
    private static Integer[] overallTickTime = new Integer[200];
    private static int renderIndex = 0;
    private static LinkedList<ResourceKey<Level>> sortingOrder = new LinkedList();
    public static int elapsedTicks = 0;
    private static Comparator<ResourceKey<Level>> sorter = (value, compare) -> {
        long totalValue = 0L;
        for (Integer time : dimTickTimes.get(value)) {
            totalValue += (long)time.intValue();
        }
        totalValue /= 200L;
        long totalCompare = 0L;
        for (Integer time : dimTickTimes.get(compare)) {
            totalCompare += (long)time.intValue();
        }
        return Long.compare(totalCompare /= 200L, totalValue);
    };
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

        public void setupRenderState() {
            RenderSystem.disableDepthTest();
        }
    };
    private static final RenderType boxNoDepth = RenderType.create((String)"ccl:box_no_depth", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setDepthTestState(DISABLE_DEPTH).createCompositeState(false));
    private static final Cuboid6 BOX = Cuboid6.full.copy().expand(0.02);
    private static final float[] RED = EnumColour.RED.getColour(128).packArray();
    public static List<Vector3> debugBlockList = null;
    int i = 0;

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.register((Object)new BCClientEventHandler());
    }

    @SubscribeEvent
    public void disconnectEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            BCEventHandler.noClipPlayers.remove(mc.player.getUUID());
        }
    }

    @SubscribeEvent
    public void tickEnd(ClientTickEvent.Post event) {
        ++elapsedTicks;
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (debugTimeout > 0) {
            --debugTimeout;
        }
        if (elapsedTicks % 100 == 0 && debugTimeout > 0) {
            sortingOrder.clear();
            sortingOrder.addAll(dimTickTimes.keySet());
            sortingOrder.sort(sorter);
        }
    }

    @SubscribeEvent
    public void drawSelectionEvent(RenderHighlightEvent.Block event) {
        BlockBCore block;
        ClientLevel level = Minecraft.getInstance().level;
        if (event.getTarget().getType() == HitResult.Type.MISS || level == null) {
            return;
        }
        BlockState state = level.getBlockState(event.getTarget().getBlockPos());
        Block block2 = state.getBlock();
        if (block2 instanceof BlockBCore && !(block = (BlockBCore)block2).renderSelectionBox(event, (Level)level)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void fovUpdate(ComputeFovModifierEvent event) {
        float originalFOV;
        Player player = event.getPlayer();
        float newFOV = originalFOV = event.getFovModifier();
        int slotIndex = 2;
        for (ItemStack stack : player.getInventory().armor) {
            if (!stack.isEmpty() && stack.getItem() instanceof IFOVModifierItem) {
                newFOV = ((IFOVModifierItem)stack.getItem()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlot.values()[slotIndex]);
            }
            ++slotIndex;
        }
        ItemStack stack = player.getOffhandItem();
        if (!stack.isEmpty() && stack.getItem() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.getItem()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlot.OFFHAND);
        }
        if (!(stack = player.getMainHandItem()).isEmpty() && stack.getItem() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.getItem()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlot.MAINHAND);
        }
        if (newFOV != originalFOV) {
            event.setNewFovModifier(newFOV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            this.doDebugRendering(event);
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        BlockEntityRenderDispatcher tileRenderDispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        LevelRenderer levelRenderer = event.getLevelRenderer();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 vec3 = event.getCamera().getPosition();
        double camX = vec3.x();
        double camY = vec3.y();
        double camZ = vec3.z();
        for (SectionRenderDispatcher.RenderSection renderChunkInfo : levelRenderer.visibleSections) {
            List list = renderChunkInfo.getCompiled().getRenderableBlockEntities();
            for (BlockEntity tile : list) {
                BlockEntityRenderer renderer;
                if (!ClientHooks.isBlockEntityRendererVisible((BlockEntityRenderDispatcher)levelRenderer.blockEntityRenderDispatcher, (BlockEntity)tile, (Frustum)event.getFrustum()) || !((renderer = tileRenderDispatcher.getRenderer(tile)) instanceof BlockEntityRendererTransparent)) continue;
                BlockEntityRendererTransparent rendererTransparent = (BlockEntityRendererTransparent)renderer;
                BlockPos pos = tile.getBlockPos();
                poseStack.pushPose();
                poseStack.translate((double)pos.getX() - camX, (double)pos.getY() - camY, (double)pos.getZ() - camZ);
                this.renderTransparent(camera, rendererTransparent, tile, event.getPartialTick().getGameTimeDeltaPartialTick(false), poseStack, (MultiBufferSource)buffers);
                poseStack.popPose();
            }
        }
        Object object = levelRenderer.globalBlockEntities;
        synchronized (object) {
            for (BlockEntity tile : levelRenderer.globalBlockEntities) {
                BlockEntityRenderer renderer;
                if (!ClientHooks.isBlockEntityRendererVisible((BlockEntityRenderDispatcher)levelRenderer.blockEntityRenderDispatcher, (BlockEntity)tile, (Frustum)event.getFrustum()) || !((renderer = tileRenderDispatcher.getRenderer(tile)) instanceof BlockEntityRendererTransparent)) continue;
                BlockEntityRendererTransparent rendererTransparent = (BlockEntityRendererTransparent)renderer;
                BlockPos blockpos3 = tile.getBlockPos();
                poseStack.pushPose();
                poseStack.translate((double)blockpos3.getX() - camX, (double)blockpos3.getY() - camY, (double)blockpos3.getZ() - camZ);
                this.renderTransparent(camera, rendererTransparent, tile, event.getPartialTick().getGameTimeDeltaPartialTick(false), poseStack, (MultiBufferSource)buffers);
                poseStack.popPose();
            }
        }
    }

    public <E extends BlockEntity> void renderTransparent(Camera camera, BlockEntityRendererTransparent<E> renderer, E tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffers) {
        if (!tile.hasLevel() || !tile.getType().isValid(tile.getBlockState())) {
            return;
        }
        if (!renderer.shouldRender(tile, camera.getPosition())) {
            return;
        }
        int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos());
        try {
            renderer.renderTransparent(tile, partialTicks, poseStack, buffers, packedLight, OverlayTexture.NO_OVERLAY);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void doDebugRendering(RenderLevelStageEvent event) {
        if (debugBlockList == null) {
            return;
        }
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack pStack = event.getPoseStack();
        pStack.pushPose();
        if (this.i++ % 100 == 0) {
            debugBlockList.sort(Comparator.comparingDouble(value -> value.distanceSquared(Vector3.fromEntity((Entity)Minecraft.getInstance().player))));
        }
        pStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        TransformingVertexConsumer consumer = new TransformingVertexConsumer(source.getBuffer(boxNoDepth), pStack);
        int i = 0;
        for (Vector3 pos : debugBlockList) {
            RenderUtils.bufferCuboidSolid((VertexConsumer)consumer, (Cuboid6)BOX.copy().add(pos), (float)RED[0], (float)RED[1], (float)RED[2], (float)RED[3]);
            if (++i <= 1000) continue;
            break;
        }
        source.endBatch();
        pStack.popPose();
    }
}

