/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class ItemEffortlessRing
extends Item {
    private static final int TICK_MODULUS = 1;
    private static final float SPEED_BONUS = 0.05f;
    private static final AttributeModifier STEP_SIZE_MODIFIER = new AttributeModifier(ResourceLocation.parse((String)"evilcraft:step_height_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private static final float JUMP_DISTANCE_FACTOR = 0.05f;
    private static final float JUMP_HEIGHT_FACTOR = 0.3f;
    private static final float FALLDISTANCE_REDUCTION = 2.0f;

    public ItemEffortlessRing(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(this::onPlayerFall);
        NeoForge.EVENT_BUS.addListener(this::onPlayerJump);
        NeoForge.EVENT_BUS.addListener(this::onPlayerUpdate);
    }

    public void adjustParameters(ItemStack itemStack, Player player) {
        AttributeInstance attribute;
        if (player.zza > 0.0f && player.onGround()) {
            player.moveRelative(player.isInWater() ? 0.016666668f : 0.05f, new Vec3(0.0, 0.0, 1.0));
        }
        if ((attribute = player.getAttribute(Attributes.STEP_HEIGHT)) != null && !attribute.hasModifier(STEP_SIZE_MODIFIER.id())) {
            attribute.addTransientModifier(STEP_SIZE_MODIFIER);
        }
    }

    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)0.3f, 0.0));
        }
    }

    public void onPlayerUpdate(EntityTickEvent.Pre event) {
        Player player;
        AttributeInstance attribute;
        if (event.getEntity() instanceof Player && (attribute = (player = (Player)event.getEntity()).getAttribute(Attributes.STEP_HEIGHT)) != null && attribute.hasModifier(STEP_SIZE_MODIFIER.id()) && !ItemStackHelpers.hasPlayerItem((Player)player, (Item)this)) {
            attribute.removeModifier(STEP_SIZE_MODIFIER.id());
        }
    }

    public void onPlayerFall(LivingFallEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            this.adjustParameters(stack, (Player)entityIn);
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

