/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockFluidBlood;

public class ItemDarkGem
extends Item {
    private static final int REQUIRED_BLOOD_BLOCKS = 5;
    private static final int TICK_MODULUS = 5;

    public ItemDarkGem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntityItemUpdate(ItemStack stack, final ItemEntity entityItem) {
        if (!entityItem.level().isClientSide() && WorldHelpers.efficientTick((Level)entityItem.level(), (int)5, (int[])new int[]{(int)entityItem.getX(), (int)entityItem.getY(), (int)entityItem.getZ()})) {
            final BlockPos blockPos = entityItem.blockPosition();
            Level world = entityItem.level();
            int amount = 0;
            if (this.isValidBlock(world, blockPos)) {
                final BlockPos[] visited = new BlockPos[5];
                visited[amount] = blockPos;
                WorldHelpers.foldArea((LevelAccessor)world, (int)3, (BlockPos)blockPos, (WorldHelpers.WorldFoldingFunction)new WorldHelpers.WorldFoldingFunction<Integer, Integer, Level>(){

                    @Nullable
                    public Integer apply(@Nullable Integer amount, Level world, BlockPos pos) {
                        if (amount == null || amount == -1) {
                            return amount;
                        }
                        if ((pos.getX() != blockPos.getX() || pos.getY() != blockPos.getY() || pos.getZ() != blockPos.getZ()) && ItemDarkGem.this.isValidBlock(world, pos)) {
                            visited[amount.intValue()] = pos;
                            if ((amount = Integer.valueOf(amount + 1)) == 5) {
                                entityItem.getItem().shrink(1);
                                entityItem.spawnAtLocation(new ItemStack(RegistryEntries.ITEM_DARK_POWER_GEM));
                                for (int restep = 0; restep < amount; ++restep) {
                                    world.setBlockAndUpdate(visited[restep], Blocks.AIR.defaultBlockState());
                                    if (world.isClientSide()) {
                                        BlockBloodStain.splash(world, visited[restep].offset(0, -1, 0));
                                    }
                                    world.updateNeighborsAt(visited[restep], Blocks.AIR);
                                }
                                return -1;
                            }
                        }
                        return amount;
                    }
                }, (Object)(++amount));
            }
        }
        return false;
    }

    private boolean isValidBlock(Level world, BlockPos blockPos) {
        return world.getBlockState(blockPos).getBlock() instanceof BlockFluidBlood && world.getFluidState(blockPos).isSource();
    }
}

