/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class ItemBroomPart
extends Item {
    public ItemBroomPart(Item.Properties properties) {
        super(properties);
    }

    public static IBroomPart getPart(ItemStack itemStack) {
        return BroomParts.REGISTRY.getPartFromItem(itemStack);
    }

    public String getDescriptionId(ItemStack itemStack) {
        IBroomPart part = ItemBroomPart.getPart(itemStack);
        if (part != null) {
            return part.getTranslationKey();
        }
        return super.getDescriptionId(itemStack);
    }

    public boolean isFoil(ItemStack stack) {
        IBroomPart part = ItemBroomPart.getPart(stack);
        if (part != null) {
            return part.isEffect();
        }
        return super.isFoil(stack);
    }

    public void fillItemCategory(NonNullList<ItemStack> list) {
        for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
            for (ItemStack itemStack : BroomParts.REGISTRY.getItemsFromPart(part)) {
                if (itemStack.getItem() != this) continue;
                list.add((Object)itemStack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int getColor(ItemStack itemStack, int renderPass) {
            IBroomPart part = ItemBroomPart.getPart(itemStack);
            if (part != null) {
                return part.getModelColor();
            }
            return -1;
        }
    }
}

