/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkBloodBrick;
import org.cyclops.evilcraft.block.BlockSpiritFurnace;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

@GameTestHolder(value="evilcraft")
@PrefixGameTestTemplate(value=false)
public class GameTestsSpiritFurnace {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10")
    public void testSpiritFurnace3x3(GameTestHelper helper) {
        this.createFurnace(helper, POS, 3);
        helper.succeedWhen(() -> this.assertFurnaceValid(helper, POS, 3));
    }

    @GameTest(template="empty10")
    public void testSpiritFurnace5x5(GameTestHelper helper) {
        this.createFurnace(helper, POS, 5);
        helper.succeedWhen(() -> this.assertFurnaceValid(helper, POS, 5));
    }

    @GameTest(template="empty10")
    public void testSpiritFurnace3x3MissingBrick(GameTestHelper helper) {
        HashSet excluded = Sets.newHashSet((Object[])new BlockPos[]{POS.above()});
        this.createFurnace(helper, POS, 3, excluded);
        helper.succeedWhen(() -> this.assertFurnaceInvalid(helper, POS, 3, excluded));
    }

    @GameTest(template="empty10")
    public void testSpiritFurnace3x3ZombieDisallowed(GameTestHelper helper) {
        BlockEntitySpiritFurnace furnace = this.createFurnace(helper, POS, 3);
        furnace.getInventory().setItem(1, GameTestsSpiritFurnace.createBox(helper, EntityType.ZOMBIE));
        helper.succeedWhen(() -> helper.assertFalse(furnace.isSizeValidForEntity(), "Furnace size should be invalid"));
    }

    @GameTest(template="empty10")
    public void testSpiritFurnace3x3ZombieAllowed(GameTestHelper helper) {
        BlockEntitySpiritFurnace furnace = this.createFurnace(helper, POS, 4);
        furnace.getInventory().setItem(1, GameTestsSpiritFurnace.createBox(helper, EntityType.ZOMBIE));
        helper.succeedWhen(() -> helper.assertTrue(furnace.isSizeValidForEntity(), "Furnace size should be valid"));
    }

    @GameTest(template="empty10", timeoutTicks=250)
    public void testSpiritFurnace3x3ChickenRun(GameTestHelper helper) {
        BlockEntitySpiritFurnace furnace = this.createFurnace(helper, POS, 3);
        furnace.getInventory().setItem(0, new ItemStack(RegistryEntries.ITEM_CONDENSED_BLOOD, 64));
        furnace.getInventory().setItem(1, GameTestsSpiritFurnace.createBox(helper, EntityType.CHICKEN));
        helper.succeedWhen(() -> helper.assertFalse(furnace.getInventory().getItem(BlockEntitySpiritFurnace.SLOTS_DROP[0]).isEmpty(), "Furnace should produce drops"));
    }

    public static ItemStack createBox(GameTestHelper helper, EntityType<?> entityType) {
        ItemStack stack = new ItemStack(RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE);
        EntityVengeanceSpirit spiritDummy = new EntityVengeanceSpirit((EntityType<? extends EntityVengeanceSpirit>)((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()), (Level)helper.getLevel());
        spiritDummy.setInnerEntityType(entityType);
        CompoundTag tag = new CompoundTag();
        spiritDummy.getData().writeNBT(tag);
        stack.set(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)tag);
        return stack;
    }

    protected BlockEntitySpiritFurnace createFurnace(GameTestHelper helper, BlockPos pos, int dimension) {
        return this.createFurnace(helper, pos, dimension, Sets.newHashSet());
    }

    protected BlockEntitySpiritFurnace createFurnace(GameTestHelper helper, BlockPos pos, int dimension, Set<BlockPos> exclude) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (exclude.contains(poso)) continue;
                    if (x == 0 && y == 0 && z == 0) {
                        helper.setBlock(poso, (Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get());
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    helper.setBlock(poso, (Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK.get());
                }
            }
        }
        return exclude.contains(pos) ? null : (BlockEntitySpiritFurnace)helper.getBlockEntity(pos);
    }

    protected void assertFurnaceValid(GameTestHelper helper, BlockPos pos, int dimension) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (x == 0 && y == 0 && z == 0) {
                        helper.assertBlockPresent((Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get(), poso);
                        helper.assertBlockProperty(poso, (Property)BlockSpiritFurnace.ACTIVE, (Comparable)Boolean.valueOf(true));
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    helper.assertBlockPresent((Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK.get(), poso);
                    helper.assertBlockProperty(poso, (Property)BlockDarkBloodBrick.ACTIVE, (Comparable)Boolean.valueOf(true));
                }
            }
        }
    }

    protected void assertFurnaceInvalid(GameTestHelper helper, BlockPos pos, int dimension, Set<BlockPos> exclude) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (exclude.contains(poso)) {
                        helper.assertBlockPresent(Blocks.AIR, poso);
                        continue;
                    }
                    if (x == 0 && y == 0 && z == 0) {
                        helper.assertBlockPresent((Block)RegistryEntries.BLOCK_SPIRIT_FURNACE.get(), poso);
                        helper.assertBlockProperty(poso, (Property)BlockSpiritFurnace.ACTIVE, (Comparable)Boolean.valueOf(false));
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    helper.assertBlockPresent((Block)RegistryEntries.BLOCK_DARK_BLOOD_BRICK.get(), poso);
                    helper.assertBlockProperty(poso, (Property)BlockDarkBloodBrick.ACTIVE, (Comparable)Boolean.valueOf(false));
                }
            }
        }
    }
}

