/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.blockentity.RendererBlockEntityEndPortalBase;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.joml.Matrix4f;

public class RenderBlockEntityBoxOfEternalClosure
extends RendererBlockEntityEndPortalBase<BlockEntityBoxOfEternalClosure> {
    private static final ResourceLocation beamTexture = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/entity/beam.png");
    private static final RenderType renderTypeBeam = RenderType.entitySmoothCutout((ResourceLocation)beamTexture);

    public RenderBlockEntityBoxOfEternalClosure(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public AABB getRenderBoundingBox(BlockEntityBoxOfEternalClosure blockEntity) {
        return AABB.INFINITE;
    }

    @Override
    public void render(BlockEntityBoxOfEternalClosure tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)tile.getLevel().getBlockState(tile.getBlockPos()), (Property)BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        matrixStackIn.pushPose();
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = -90;
        }
        if (direction == Direction.NORTH) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = 180;
        }
        if (direction == Direction.EAST) {
            rotation = 0;
        }
        matrixStackIn.translate(0.5f, 0.5f, 0.5f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)rotation));
        matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
        BlockState blockState = (BlockState)tile.getBlockState().setValue((Property)BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStackIn.last(), bufferIn.getBuffer(Sheets.solidBlockSheet()), blockState, ModelBoxOfEternalClosureBaked.boxModel, 1.0f, 1.0f, 1.0f, combinedLightIn, OverlayTexture.NO_OVERLAY);
        float angle = tile.getPreviousLidAngle() + (tile.getLidAngle() - tile.getPreviousLidAngle()) * partialTicks;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.75f, 0.375f, 0.0f);
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-angle));
        matrixStackIn.translate(-0.75f, -0.375f, 0.0f);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrixStackIn.last(), bufferIn.getBuffer(Sheets.solidBlockSheet()), blockState, ModelBoxOfEternalClosureBaked.boxLidModel, 1.0f, 1.0f, 1.0f, combinedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        if (angle > 0.0f) {
            super.render(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        matrixStackIn.popPose();
        EntityVengeanceSpirit target = tile.getTargetSpirit();
        if (target != null) {
            float f = RenderBlockEntityBoxOfEternalClosure.getY(tile, partialTicks);
            BlockPos blockpos = tile.getBlockPos();
            float f3 = (float)target.getX() + 0.5f;
            float f4 = (float)target.getY() + 0.5f - target.getEyeHeight() / 2.0f;
            float f5 = (float)target.getZ() + 0.5f;
            float f6 = (float)((double)f3 - (double)blockpos.getX());
            float f7 = (float)((double)f4 - (double)blockpos.getY());
            float f8 = (float)((double)f5 - (double)blockpos.getZ());
            matrixStackIn.translate(f6, f7, f8);
            MultiBufferSource bufferOverride = type -> bufferIn.getBuffer(renderTypeBeam);
            EnderDragonRenderer.renderCrystalBeams((float)(-f6), (float)(-f7 + f), (float)(-f8), (float)partialTicks, (int)tile.innerRotation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferOverride, (int)combinedLightIn);
        }
    }

    @Override
    public boolean shouldRenderFace(Direction direction) {
        return direction == Direction.UP;
    }

    public static float getY(BlockEntityBoxOfEternalClosure p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = Mth.sin((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    public void renderCube(BlockEntityBoxOfEternalClosure tile, Matrix4f p_228883_4_, VertexConsumer vb) {
        this.renderFace(tile, p_228883_4_, vb, 0.3125f, 0.6875f, -0.5f, -0.5f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }
}

