/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.common;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContentsPayload;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageSettingsContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedSophisticatedStorage;

public class MountedStorageSettingsContainerMenu
extends MountedStorageSettingsContainerMenuBase {
    private final boolean doubleChest;

    protected MountedStorageSettingsContainerMenu(int windowId, Player player, int contraptionEntityId, BlockPos localPos) {
        this(ModContent.MOUNTED_STORAGE_SETTINGS_CONTAINER_TYPE.get(), windowId, player, contraptionEntityId, localPos);
    }

    protected MountedStorageSettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, int contraptionEntityId, BlockPos localPos) {
        super(menuType, windowId, player, MountedStorageSettingsContainerMenu.getWrapper(player.level(), contraptionEntityId, localPos), contraptionEntityId, localPos);
        MountedSophisticatedStorage mountedSophisticatedStorage;
        AbstractContraptionEntity cEntity;
        MountedStorageBase mountedStorageBase;
        Entity entity = this.getPlayer().level().getEntity(this.getContraptionEntityId());
        this.doubleChest = entity instanceof AbstractContraptionEntity ? (mountedStorageBase = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)(cEntity = (AbstractContraptionEntity)entity), (BlockPos)this.getLocalPos())) instanceof MountedSophisticatedStorage && (mountedSophisticatedStorage = (MountedSophisticatedStorage)mountedStorageBase).getStorageHolder().isDoubleChest() : false;
    }

    private static IStorageWrapper getWrapper(Level level, int contraptionEntityId, BlockPos localPos) {
        Entity entity = level.getEntity(contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        MountedStorageBase itemStorage = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)contraptionEntity, (BlockPos)localPos);
        if (itemStorage == null) {
            return NoopStorageWrapper.INSTANCE;
        }
        return itemStorage.getStorageWrapper();
    }

    protected CompoundTag getSettingsTag(CompoundTag contents) {
        return contents.getCompound("settings");
    }

    public static MountedStorageSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MountedStorageSettingsContainerMenu(windowId, playerInventory.player, buffer.readInt(), buffer.readBlockPos());
    }

    public boolean supportsItemDisplaySideSelection() {
        return this.doubleChest;
    }

    protected CustomPacketPayload instantiateSettingsPayload(UUID uuid, CompoundTag settingsContents) {
        return new MountedStorageContentsPayload(uuid, settingsContents);
    }

    protected void updateFromContents(UUID uuid) {
        MountedStorageData storage = MountedStorageData.get((UUID)uuid);
        if (storage.removeUpdatedStorageSettingsFlag(uuid)) {
            CompoundTag contents = storage.getContents();
            this.storageWrapper.getSettingsHandler().reloadFrom(this.getSettingsTag(contents));
        }
    }
}

