/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.tools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsstorage.modules.scanner.tools.ItemFilterCache;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class InventoryAccessSettings {
    private boolean blockInputGui = false;
    private boolean blockInputAuto = false;
    private boolean blockInputScreen = false;
    private boolean blockOutputGui = false;
    private boolean blockOutputAuto = false;
    private boolean blockOutputScreen = false;
    public static final int FILTER_SIZE = 18;
    private boolean metaMode = false;
    private boolean nbtMode = false;
    private boolean blacklist = false;
    private final ItemStackList filters = ItemStackList.create((int)18);
    public static final MapCodec<InventoryAccessSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("biInGui").forGetter(settings -> settings.blockInputGui), (App)Codec.BOOL.fieldOf("biInAuto").forGetter(settings -> settings.blockInputAuto), (App)Codec.BOOL.fieldOf("biInScreen").forGetter(settings -> settings.blockInputScreen), (App)Codec.BOOL.fieldOf("biOutGui").forGetter(settings -> settings.blockOutputGui), (App)Codec.BOOL.fieldOf("biOutAuto").forGetter(settings -> settings.blockOutputGui), (App)Codec.BOOL.fieldOf("biOutScreen").forGetter(settings -> settings.blockOutputGui), (App)Codec.BOOL.fieldOf("meta").forGetter(settings -> settings.metaMode), (App)Codec.BOOL.fieldOf("comp").forGetter(settings -> settings.nbtMode), (App)Codec.BOOL.fieldOf("blacklist").forGetter(settings -> settings.blacklist), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("filters").forGetter(settings -> settings.filters)).apply((Applicative)instance, InventoryAccessSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryAccessSettings> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockInputGui, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockInputAuto, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockInputScreen, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockOutputGui, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockOutputGui, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blockOutputGui, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.metaMode, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.nbtMode, (StreamCodec)ByteBufCodecs.BOOL, settings -> settings.blacklist, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, settings -> settings.filters, InventoryAccessSettings::new);
    private Predicate<ItemStack> matcher = null;

    public InventoryAccessSettings(boolean blockInputGui, boolean blockInputAuto, boolean blockInputScreen, boolean blockOutputGui, boolean blockOutputAuto, boolean blockOutputScreen, boolean metaMode, boolean nbtMode, boolean blacklist, List<ItemStack> filters) {
        this.blockInputGui = blockInputGui;
        this.blockInputAuto = blockInputAuto;
        this.blockInputScreen = blockInputScreen;
        this.blockOutputGui = blockOutputGui;
        this.blockOutputAuto = blockOutputAuto;
        this.blockOutputScreen = blockOutputScreen;
        this.metaMode = metaMode;
        this.nbtMode = nbtMode;
        this.blacklist = blacklist;
        this.filters.clear();
        for (int i = 0; i < Math.min(this.filters.size(), filters.size()); ++i) {
            this.filters.set(i, (Object)filters.get(i));
        }
    }

    public InventoryAccessSettings() {
    }

    public ItemStackList getFilters() {
        return this.filters;
    }

    public boolean isMetaMode() {
        return this.metaMode;
    }

    public void setMetaMode(boolean metaMode) {
        this.metaMode = metaMode;
    }

    public boolean isNbtMode() {
        return this.nbtMode;
    }

    public void setNbtMode(boolean nbtMode) {
        this.nbtMode = nbtMode;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(boolean blacklist) {
        this.blacklist = blacklist;
    }

    public boolean isBlockInputGui() {
        return this.blockInputGui;
    }

    public void setBlockInputGui(boolean blockInputGui) {
        this.blockInputGui = blockInputGui;
    }

    public boolean isBlockInputAuto() {
        return this.blockInputAuto;
    }

    public void setBlockInputAuto(boolean blockInputAuto) {
        this.blockInputAuto = blockInputAuto;
    }

    public boolean isBlockInputScreen() {
        return this.blockInputScreen;
    }

    public void setBlockInputScreen(boolean blockInputScreen) {
        this.blockInputScreen = blockInputScreen;
    }

    public boolean isBlockOutputGui() {
        return this.blockOutputGui;
    }

    public void setBlockOutputGui(boolean blockOutputGui) {
        this.blockOutputGui = blockOutputGui;
    }

    public boolean isBlockOutputScreen() {
        return this.blockOutputScreen;
    }

    public void setBlockOutputScreen(boolean blockOutputScreen) {
        this.blockOutputScreen = blockOutputScreen;
    }

    public boolean isBlockOutputAuto() {
        return this.blockOutputAuto;
    }

    public void setBlockOutputAuto(boolean blockOutputAuto) {
        this.blockOutputAuto = blockOutputAuto;
    }

    public boolean inputBlocked() {
        return this.blockInputGui || this.blockInputScreen || this.blockInputAuto;
    }

    public boolean outputBlocked() {
        return this.blockOutputGui || this.blockOutputScreen || this.blockOutputAuto;
    }

    public Predicate<ItemStack> getMatcher() {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack : this.filters) {
                if (stack.isEmpty()) continue;
                filterList.add((Object)stack);
            }
            if (filterList.isEmpty()) {
                this.matcher = itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.blacklist, this.nbtMode, filterList);
                this.matcher = filterCache::match;
            }
        }
        return this.matcher;
    }
}

