/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.List;
import java.util.Optional;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.scanner.client.GuiStorageScanner;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketReturnInventoryInfo(List<InventoryInfo> inventories) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"return_inventory_info");
    public static final CustomPacketPayload.Type<PacketReturnInventoryInfo> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketReturnInventoryInfo> CODEC = StreamCodec.composite((StreamCodec)InventoryInfo.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketReturnInventoryInfo::inventories, PacketReturnInventoryInfo::new);

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            GuiStorageScanner.fromServer_inventories = this.getInventories();
        });
    }

    public record InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
        public static final StreamCodec<FriendlyByteBuf, InventoryInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, InventoryInfo::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, InventoryInfo::name, (StreamCodec)ByteBufCodecs.BOOL, InventoryInfo::routable, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), s -> s.block == null ? Optional.empty() : Optional.of(Tools.getId((Block)s.block)), (pos, name, routable, blockId) -> new InventoryInfo((BlockPos)pos, (String)name, (boolean)routable, blockId.map(Tools::getBlock).orElse(null)));
    }
}

