/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner;

import java.util.function.Supplier;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.blocks.RemoteStorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerBlock;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.client.ClientCommandHandler;
import mcjty.rftoolsstorage.modules.scanner.client.GuiStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.data.StorageScannerData;
import mcjty.rftoolsstorage.modules.scanner.items.DumpModuleItem;
import mcjty.rftoolsstorage.modules.scanner.items.DumpScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlModuleItem;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import mcjty.rftoolsstorage.setup.Config;
import mcjty.rftoolsstorage.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class StorageScannerModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, StorageScannerTileEntity> STORAGE_SCANNER = Registration.RBLOCKS.registerBlock("storage_scanner", StorageScannerTileEntity.class, StorageScannerBlock::new, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), StorageScannerTileEntity::new);
    public static final Supplier<MenuType<StorageScannerContainer>> CONTAINER_STORAGE_SCANNER = Registration.CONTAINERS.register("storage_scanner", GenericContainer::createContainerType);
    public static final Supplier<MenuType<RemoteStorageScannerContainer>> CONTAINER_STORAGE_SCANNER_REMOTE = Registration.CONTAINERS.register("storage_scanner_remote", () -> GenericContainer.createRemoteContainerType(StorageScannerTileEntity::new, StorageScannerContainer::createRemote, (int)3));
    public static final DeferredItem<Item> STORAGECONTROL_MODULE = Registration.ITEMS.register("storage_control_module", RFToolsStorage.tab(StorageControlModuleItem::new));
    public static final DeferredItem<Item> DUMP_MODULE = Registration.ITEMS.register("dump_module", RFToolsStorage.tab(DumpModuleItem::new));
    public static final DeferredItem<TabletItem> TABLET_SCANNER = Registration.ITEMS.register("tablet_scanner", RFToolsStorage.tab(TabletItem::new));
    public static final Supplier<AttachmentType<StorageScannerData>> STORAGE_SCANNER_DATA = Registration.ATTACHMENT_TYPES.register("storage_scanner_data", () -> AttachmentType.builder(() -> StorageScannerData.DEFAULT).serialize(StorageScannerData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<StorageScannerData>> ITEM_STORAGE_SCANNER_DATA = Registration.COMPONENTS.registerComponentType("storage_scanner_data", builder -> builder.persistent(StorageScannerData.CODEC).networkSynchronized(StorageScannerData.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CraftingGrid>> ITEM_CRAFTING_GRID_DATA = Registration.COMPONENTS.registerComponentType("crafting_grid_data", builder -> builder.persistent(CraftingGrid.CODEC).networkSynchronized(CraftingGrid.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DumpScreenModule>> MODULE_DUMP_DATA = Registration.COMPONENTS.registerComponentType("module_dump_data", builder -> builder.persistent(DumpScreenModule.CODEC).networkSynchronized(DumpScreenModule.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<StorageControlScreenModule>> MODULE_CONTROL_DATA = Registration.COMPONENTS.registerComponentType("module_control_data", builder -> builder.persistent(StorageControlScreenModule.CODEC).networkSynchronized(StorageControlScreenModule.STREAM_CODEC));

    public StorageScannerModule(IEventBus bus) {
        bus.addListener(this::registerMenuScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientCommandHandler.registerCommands());
    }

    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        GuiStorageScanner.register(event);
    }

    public void initConfig(IEventBus bus) {
        StorageScannerConfiguration.init(Config.SERVER_BUILDER, Config.CLIENT_BUILDER);
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(STORAGE_SCANNER).ironPickaxeTags().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_STORAGE_SCANNER_DATA.get(), (DataComponentType)ITEM_CRAFTING_GRID_DATA.get()}).shaped(builder -> builder.define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"ToT", "gFg", "ToT"}), Dob.itemBuilder(STORAGECONTROL_MODULE).shaped(builder -> builder.define(Character.valueOf('X'), (ItemLike)Items.CRAFTING_TABLE).unlockedBy("ingot", DataGen.has((ItemLike)Items.IRON_INGOT)), new String[]{" X ", "rir", " X "}), Dob.itemBuilder(DUMP_MODULE).shaped(builder -> builder.define(Character.valueOf('X'), ItemTags.WOODEN_BUTTONS).unlockedBy("ingot", DataGen.has((ItemLike)Items.IRON_INGOT)), new String[]{" X ", "rir", " X "}), Dob.itemBuilder(TABLET_SCANNER)});
    }
}

