/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.IItemKey;
import mcjty.rftoolsstorage.craftinggrid.IItemSource;
import mcjty.rftoolsstorage.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftoolsstorage.craftinggrid.PacketGridToClient;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCraftingTools {
    @Nonnull
    private static List<Pair<ItemStack, Integer>> tryRecipe(Player player, RFCraftingRecipe craftingRecipe, int n, IItemSource itemSource) {
        int i;
        TransientCraftingContainer workInventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean stillValid(@Nonnull Player var1) {
                return false;
            }

            public ItemStack quickMoveStack(Player player, int slot) {
                return ItemStack.EMPTY;
            }
        }, 3, 3);
        Optional<RecipeHolder<CraftingRecipe>> recipe = craftingRecipe.getCachedRecipe(player.getCommandSenderWorld());
        List ingredients = (List)recipe.map(r -> ((CraftingRecipe)r.value()).getIngredients()).orElseGet(() -> NonNullList.withSize((int)9, (Object)Ingredient.EMPTY));
        ArrayList<Pair> missing = new ArrayList<Pair>(9);
        for (i = 0; i < 9; ++i) {
            missing.add(Pair.of((Object)ItemStack.EMPTY, (Object)0));
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack;
            Ingredient ingredient;
            ItemStack[] stacks;
            if (i < ingredients.size() && (stacks = (ingredient = (Ingredient)ingredients.get(i)).getItems()).length > 0 && !(stack = stacks[0]).isEmpty()) {
                missing.set(i, Pair.of((Object)stack, (Object)(stack.getCount() * n)));
            }
            workInventory.setItem(i, ItemStack.EMPTY);
        }
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            int size = input.getCount();
            if (input.isEmpty()) continue;
            for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                if ((Integer)((Pair)missing.get(i2)).getRight() <= 0 || !((Ingredient)ingredients.get(i2)).test(input)) continue;
                if (size > (Integer)((Pair)missing.get(i2)).getRight()) {
                    size -= ((Integer)((Pair)missing.get(i2)).getRight()).intValue();
                    missing.set(i2, Pair.of((Object)ItemStack.EMPTY, (Object)0));
                } else {
                    missing.set(i2, Pair.of((Object)((ItemStack)((Pair)missing.get(i2)).getLeft()), (Object)((Integer)((Pair)missing.get(i2)).getRight() - size)));
                    size = 0;
                }
                workInventory.setItem(i2, input.copy());
            }
        }
        return missing.stream().filter(p -> (Integer)p.getRight() > 0).collect(Collectors.toList());
    }

    private static List<ItemStack> testAndConsumeCraftingItems(Player player, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        ArrayList undo = new ArrayList();
        ArrayList result = new ArrayList();
        Optional<RecipeHolder<CraftingRecipe>> recipe = craftingRecipe.getCachedRecipe(player.getCommandSenderWorld());
        return recipe.map(rh -> {
            CraftingRecipe r = (CraftingRecipe)rh.value();
            int w = 3;
            int h = 3;
            if (r instanceof ShapedRecipe) {
                w = ((ShapedRecipe)r).getWidth();
                h = ((ShapedRecipe)r).getHeight();
            }
            NonNullList ingredients = r.getIngredients();
            ArrayList<ItemStack> inventory = new ArrayList<ItemStack>(9);
            for (int i = 0; i < 9; ++i) {
                inventory.add(ItemStack.EMPTY);
            }
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    ItemStack stack;
                    Ingredient ingredient;
                    ItemStack[] stacks;
                    int i = y * w + x;
                    int workIndex = y * 3 + x;
                    inventory.set(workIndex, ItemStack.EMPTY);
                    if (i >= ingredients.size() || (stacks = (ingredient = (Ingredient)ingredients.get(i)).getItems()).length <= 0 || (stack = stacks[0]).isEmpty()) continue;
                    int count = stack.getCount();
                    count = StorageCraftingTools.findMatchingItems(inventory, undo, workIndex, (Ingredient)ingredients.get(i), count, itemSource);
                    if (count <= 0) continue;
                    StorageCraftingTools.undo(player, itemSource, undo);
                    return Collections.emptyList();
                }
            }
            CraftingInput workInventory = CraftingInput.of((int)3, (int)3, inventory);
            if (!r.matches((RecipeInput)workInventory, player.getCommandSenderWorld())) {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
                return result;
            }
            ItemStack stack = BaseRecipe.assemble((Recipe)r, (RecipeInput)workInventory, (Level)player.level());
            if (!stack.isEmpty()) {
                result.add(stack);
                NonNullList remaining = r.getRemainingItems((RecipeInput)workInventory);
                for (ItemStack s : remaining) {
                    if (s.isEmpty()) continue;
                    result.add(s);
                }
            } else {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
            }
            return result;
        }).orElse(result);
    }

    private static int findMatchingItems(List<ItemStack> workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, @Nonnull Ingredient stack, int count, IItemSource itemSource) {
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (!input.isEmpty() && stack.test(input)) {
                int ss = count;
                if (input.getCount() - ss < 0) {
                    ss = input.getCount();
                }
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack copy = input.copy();
                ItemStack actuallyExtracted = itemSource.decrStackSize(key, ss);
                if (!actuallyExtracted.isEmpty()) {
                    workInventory.set(i, copy);
                    count -= ss;
                    undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)actuallyExtracted));
                }
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(Player player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.copy();
            copy.setCount(amountLeft);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)copy);
        }
        player.containerMenu.broadcastChanges();
    }

    public static void craftItems(Player player, int nn, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<RecipeHolder<CraftingRecipe>> recipe = craftingRecipe.getCachedRecipe(player.getCommandSenderWorld());
        if (!recipe.isPresent()) {
            return;
        }
        int[] n = new int[]{nn};
        recipe.ifPresent(rh -> {
            CraftingRecipe r = (CraftingRecipe)rh.value();
            ItemStack recipeResult = BaseRecipe.getResultItem((Recipe)r, (Level)player.level());
            if (!recipeResult.isEmpty() && recipeResult.getCount() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.getMaxStackSize();
                }
                int remainder = n[0] % recipeResult.getCount();
                n[0] = n[0] / recipeResult.getCount();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.getCount() > recipeResult.getMaxStackSize()) {
                    n[0] = n[0] - 1;
                }
                for (int i = 0; i < n[0]; ++i) {
                    List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource);
                    if (result.isEmpty()) {
                        return;
                    }
                    for (ItemStack stack : result) {
                        if (player.getInventory().add(stack)) continue;
                        player.spawnAtLocation(stack, 1.05f);
                    }
                }
            }
        });
    }

    @Nonnull
    public static List<Pair<ItemStack, Integer>> testCraftItems(Player player, int nn, RFCraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<RecipeHolder<CraftingRecipe>> recipe = craftingRecipe.getCachedRecipe(player.getCommandSenderWorld());
        if (!recipe.isPresent()) {
            return Collections.emptyList();
        }
        int[] n = new int[]{nn};
        return recipe.map(rh -> {
            CraftingRecipe r = (CraftingRecipe)rh.value();
            ItemStack recipeResult = BaseRecipe.getResultItem((Recipe)r, (Level)player.level());
            if (!recipeResult.isEmpty() && recipeResult.getCount() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.getMaxStackSize();
                }
                int remainder = n[0] % recipeResult.getCount();
                n[0] = n[0] / recipeResult.getCount();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.getCount() > recipeResult.getMaxStackSize()) {
                    n[0] = n[0] - 1;
                }
                return StorageCraftingTools.tryRecipe(player, craftingRecipe, n[0], itemSource);
            }
            return Collections.emptyList();
        }).orElse(Collections.emptyList());
    }

    public static void craftFromGrid(Player player, int count, boolean test, BlockPos pos, ResourceKey<Level> type) {
        List<Pair<ItemStack, Integer>> testResult = Collections.emptyList();
        BlockEntity te = LevelTools.getLevel((Level)player.getCommandSenderWorld(), type).getBlockEntity(pos);
        if (te instanceof CraftingGridProvider) {
            CraftingGridProvider provider = (CraftingGridProvider)te;
            testResult = provider.craft(player, count, test);
        }
        if (!testResult.isEmpty()) {
            RFToolsStorageMessages.sendToPlayer(PacketCraftTestResultToClient.create(testResult), player);
        }
    }

    public static void requestGridSync(Player player, BlockPos pos, ResourceKey<Level> type) {
        boolean dummy;
        ServerLevel world = LevelTools.getLevel((Level)player.getCommandSenderWorld(), type);
        CraftingGridProvider provider = null;
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof CraftingGridProvider && te instanceof GenericTileEntity) {
            provider = (CraftingGridProvider)te;
        }
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            v0 = scanner.isDummy();
        } else {
            v0 = dummy = false;
        }
        if (provider != null) {
            RFToolsStorageMessages.sendToPlayer(PacketGridToClient.create(dummy ? null : pos, (ResourceKey<Level>)((GenericTileEntity)te).getDimension(), provider.getCraftingGrid()), player);
        }
    }
}

