/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class CraftingGrid {
    private final CraftingGridInventory craftingGridInventory;
    private final RFCraftingRecipe[] recipes = new RFCraftingRecipe[6];
    public static final Codec<CraftingGrid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CraftingGridInventory.CODEC.fieldOf("inventory").forGetter(CraftingGrid::getCraftingGridInventory), (App)RFCraftingRecipe.CODEC.listOf().fieldOf("recipes").forGetter(grid -> List.of(grid.recipes))).apply((Applicative)instance, CraftingGrid::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingGrid> STREAM_CODEC = StreamCodec.composite(CraftingGridInventory.STREAM_CODEC, CraftingGrid::getCraftingGridInventory, (StreamCodec)RFCraftingRecipe.STREAM_CODEC.apply(ByteBufCodecs.list()), s -> List.of(s.recipes), CraftingGrid::new);

    public CraftingGrid() {
        this.craftingGridInventory = new CraftingGridInventory();
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = new RFCraftingRecipe();
        }
    }

    public CraftingGrid(CraftingGridInventory craftingGridInventory, List<RFCraftingRecipe> recipes) {
        this.craftingGridInventory = craftingGridInventory;
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = i < recipes.size() ? recipes.get(i) : new RFCraftingRecipe();
        }
    }

    public void set(CraftingGrid grid) {
        this.craftingGridInventory.set(grid.craftingGridInventory);
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = grid.recipes[i];
        }
    }

    public CraftingGridInventory getCraftingGridInventory() {
        return this.craftingGridInventory;
    }

    public RFCraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public RFCraftingRecipe getActiveRecipe() {
        RFCraftingRecipe recipe = new RFCraftingRecipe();
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
        return recipe;
    }

    public void setRecipe(int index, ItemStack[] stacks) {
        RFCraftingRecipe recipe = this.recipes[index];
        recipe.setResult(stacks[0]);
        for (int i = 0; i < 9; ++i) {
            recipe.getInventory().set(i, stacks[i + 1]);
        }
    }

    public void storeRecipe(int index) {
        RFCraftingRecipe recipe = this.getRecipe(index);
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
    }

    public void selectRecipe(int index) {
        RFCraftingRecipe recipe = this.getRecipe(index);
        this.craftingGridInventory.setStackInSlot(0, recipe.getResult());
        for (int i = 0; i < 9; ++i) {
            this.craftingGridInventory.setStackInSlot(i + 1, recipe.getInventory().get(i));
        }
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag tagCompound = new CompoundTag();
        ListTag bufferTagList = new ListTag();
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            ItemStack stack = this.craftingGridInventory.getStackInSlot(i);
            Tag tag = stack.saveOptional(provider);
            bufferTagList.add((Object)tag);
        }
        tagCompound.put("grid", (Tag)bufferTagList);
        ListTag recipeTagList = new ListTag();
        for (RFCraftingRecipe recipe : this.recipes) {
            CompoundTag tag = new CompoundTag();
            recipe.writeToNBT(tag, provider);
            recipeTagList.add((Object)tag);
        }
        tagCompound.put("recipes", (Tag)recipeTagList);
        return tagCompound;
    }

    public void readFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        if (tagCompound == null) {
            return;
        }
        ListTag bufferTagList = tagCompound.getList("grid", 10);
        for (int i = 0; i < this.craftingGridInventory.getSlots(); ++i) {
            CompoundTag tag = bufferTagList.getCompound(i);
            this.craftingGridInventory.setStackInSlot(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag));
        }
        ListTag recipeTagList = tagCompound.getList("recipes", 10);
        for (int i = 0; i < recipeTagList.size(); ++i) {
            this.recipes[i] = new RFCraftingRecipe();
            CompoundTag tag = recipeTagList.getCompound(i);
            this.recipes[i].readFromNBT(tag, provider);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftingGrid that = (CraftingGrid)o;
        return Objects.equals(this.craftingGridInventory, that.craftingGridInventory) && Arrays.equals(this.recipes, that.recipes);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.craftingGridInventory);
        result = 31 * result + Arrays.hashCode(this.recipes);
        return result;
    }
}

