/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat.xnet;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsstorage.compat.xnet.StorageConnectorSettings;
import mcjty.rftoolsstorage.compat.xnet.XNetSupport;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.tools.InventoryAccessSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class StorageChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"textures/gui/guielements.png");
    private List<Pair<SidedConsumer, StorageConnectorSettings>> storageControllers = null;
    private Map<BlockPos, InventoryAccessSettings> access = null;
    private int delay = 0;
    public static final MapCodec<StorageChannelSettings> CODEC = MapCodec.unit(StorageChannelSettings::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageChannelSettings> STREAM_CODEC = StreamCodec.of((o, settings) -> {}, buf -> new StorageChannelSettings());

    public IChannelType getType() {
        return XNetSupport.storageChannelType;
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public void tick(int channel, IControllerContext context) {
        if (this.updateCache(channel, context)) {
            this.delay = 0;
        }
        --this.delay;
        if (this.delay > 0) {
            return;
        }
        this.delay = 10;
        Level world = context.getControllerWorld();
        for (Pair<SidedConsumer, StorageConnectorSettings> entry : this.storageControllers) {
            BlockEntity te;
            Direction side;
            BlockPos pos;
            BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId());
            if (extractorPos == null || !LevelTools.isLoaded((Level)world, (BlockPos)(pos = extractorPos.relative(side = ((SidedConsumer)entry.getKey()).side()))) || !((te = world.getBlockEntity(pos)) instanceof StorageScannerTileEntity)) continue;
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            scanner.register(this.access);
        }
    }

    private BlockPos getInventory(IControllerContext context, SidedConsumer sidedConsumer) {
        BlockPos consumerPos = context.findConsumerPosition(sidedConsumer.consumerId());
        if (consumerPos != null) {
            IItemHandler handler;
            Direction side = sidedConsumer.side();
            BlockPos pos = consumerPos.relative(side);
            BlockEntity te = context.getControllerWorld().getBlockEntity(pos);
            if (te != null && (handler = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null)) != null) {
                return pos;
            }
        }
        return null;
    }

    private boolean updateCache(int channel, IControllerContext context) {
        if (this.storageControllers == null) {
            StorageConnectorSettings con;
            this.storageControllers = new ArrayList<Pair<SidedConsumer, StorageConnectorSettings>>();
            this.access = new HashMap<BlockPos, InventoryAccessSettings>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (StorageConnectorSettings)((Object)entry.getValue());
                this.addInventory(context, entry, con);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (StorageConnectorSettings)((Object)entry.getValue());
                this.addInventory(context, entry, con);
            }
            return true;
        }
        return false;
    }

    private void addInventory(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, StorageConnectorSettings con) {
        if (con.getMode() == StorageConnectorSettings.Mode.STORAGE) {
            this.storageControllers.add((Pair<SidedConsumer, StorageConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)((Object)con)));
        } else {
            BlockPos inventory = this.getInventory(context, entry.getKey());
            if (inventory != null) {
                this.access.put(inventory, ((StorageConnectorSettings)entry.getValue()).getAccessSettings());
            }
        }
    }

    public void cleanCache() {
        this.storageControllers = null;
        this.access = null;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 0, 57, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }
}

