/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookModLoadedConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmeltingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.datagen.book.getting_started.BookshelfBindingEntry;
import com.klikli_dev.occultism.datagen.book.getting_started.RitualSatchelsEntry;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookBindingCraftingRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class GettingStartedCategory
extends CategoryProvider {
    public static final String COLOR_PURPLE = "ad03fc";
    public static final String DEMONS_DREAM = "Demon's Dream";
    public static final String CATEGORY_ID = "getting_started";

    public GettingStartedCategory(ModonomiconProviderBase parent) {
        super(parent);
    }

    protected String[] generateEntryMap() {
        return new String[]{"__________________________________", "__________________________________", "__________________________________", "__________________________P___D___", "__________________________________", "______\u0155___t___B_______g_I_O_l_M___", "__________________________________", "______i___r___\u00e7_b_______s_________", "__________________________________", "______d___f_c_____R___a___\u011d_______", "__________________________________", "______e_h_____\u1ea1_______m___________", "__________________________________", "______________\u00c1_\u00c9_C_p_S___w_x_y_z_"};
    }

    protected void generateEntries() {
        BookEntryModel introEntry = this.add(this.makeIntroEntry(this.entryMap, 'i'));
        BookEntryModel demonsDreamEntry = this.add(this.makeDemonsDreamEntry(this.entryMap, 'd'));
        demonsDreamEntry.withParent(BookEntryParentModel.create((ResourceLocation)introEntry.getId()));
        BookEntryModel spiritFireEntry = this.add(this.makeSpiritFireEntry(this.entryMap, 'f'));
        spiritFireEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel healingSpiritsEntry = this.add(this.makeHealingSpiritsEntry(this.entryMap, 'h'));
        healingSpiritsEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel thirdEyeEntry = this.add(this.makeThirdEyeEntry(this.entryMap, 'e'));
        thirdEyeEntry.withParent(BookEntryParentModel.create((ResourceLocation)demonsDreamEntry.getId()));
        BookEntryModel divinationRodEntry = this.add(this.makeDivinationRodEntry(this.entryMap, 'r'));
        divinationRodEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritFireEntry.getId()));
        BookEntryModel theurgyDivinationRodEntry = this.add(this.makeTheurgyDivinationRodsEntry(this.entryMap, 't'));
        theurgyDivinationRodEntry.withParent(BookEntryParentModel.create((ResourceLocation)divinationRodEntry.getId())).withCondition((BookConditionModel)BookAndConditionModel.create().withChildren(new BookConditionModel[]{BookEntryReadConditionModel.create().withEntry(divinationRodEntry.getId()), BookModLoadedConditionModel.create().withModId("theurgy")})).hideWhileLocked(true);
        BookEntryModel candleEntry = this.add(this.makeCandleEntry(this.entryMap, 'c'));
        candleEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritFireEntry.getId()));
        BookEntryModel ritualPrepChalkEntry = this.add(this.makeRitualPrepChalkEntry(this.entryMap, '\u00e7'));
        ritualPrepChalkEntry.withParent(BookEntryParentModel.create((ResourceLocation)candleEntry.getId()));
        BookEntryModel brushEntry = this.add(this.makeBrushEntry(this.entryMap, 'B'));
        brushEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepChalkEntry.getId()));
        BookEntryModel ritualPrepBowlEntry = this.add(this.makeRitualPrepBowlEntry(this.entryMap, 'b'));
        ritualPrepBowlEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepChalkEntry.getId()));
        BookEntryModel booksOfBinding = this.add(this.makeBooksOfBindingEntry(this.entryMap, '\u1ea1'));
        booksOfBinding.withParent(BookEntryParentModel.create((ResourceLocation)candleEntry.getId()));
        BookEntryModel booksOfBindingAutomation = this.add(this.makeBooksOfBindingAutomationEntry(this.entryMap, '\u00c1'));
        booksOfBindingAutomation.withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel bookshelfBinding = this.add(new BookshelfBindingEntry(this).generate('\u00c9'));
        bookshelfBinding.withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel booksOfCalling = this.add(this.makeBooksOfCallingEntry(this.entryMap, 'C'));
        booksOfCalling.withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel ritualEntry = this.add(this.makeRitualEntry(this.entryMap, 'R'));
        ritualEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualPrepBowlEntry.getId())).withParent(BookEntryParentModel.create((ResourceLocation)booksOfBinding.getId()));
        BookEntryModel advancedChalksEntry = this.add(this.makeChalksEntry(this.entryMap, 'a'));
        advancedChalksEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualEntry.getId()));
        BookEntryModel ritualSatchelsEntry = this.add(new RitualSatchelsEntry(this).generate('\u011d'));
        ritualSatchelsEntry.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/craft_djinni")));
        BookEntryModel moreRitualsEntry = this.add(this.makeMoreRitualsEntry(this.entryMap, 'm'));
        moreRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId()));
        BookEntryModel greyParticlesEntry = this.add(this.makeGreyParticlesEntry(this.entryMap, 'p'));
        greyParticlesEntry.withParent(BookEntryParentModel.create((ResourceLocation)ritualEntry.getId()));
        BookEntryModel spiritsSubcategory = this.add(this.makeSpiritsSubcategoryEntry(this.entryMap, 'S'));
        spiritsSubcategory.withParent(BookEntryParentModel.create((ResourceLocation)greyParticlesEntry.getId()));
        BookEntryModel otherworldGoggles = this.add(this.makeOtherworldGogglesEntry(this.entryMap, 'g'));
        otherworldGoggles.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/craft_foliot")));
        BookEntryModel infusedPickaxe = this.add(this.makeInfusedPickaxeEntry(this.entryMap, 'I'));
        infusedPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)otherworldGoggles.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/craft_djinni")));
        BookEntryModel iesnium = this.add(this.makeIesniumEntry(this.entryMap, 'O'));
        iesnium.withParent(BookEntryParentModel.create((ResourceLocation)infusedPickaxe.getId()));
        BookEntryModel iesniumPickaxe = this.add(this.makeIesniumPickaxeEntry(this.entryMap, 'P'));
        iesniumPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)iesnium.getId()));
        BookEntryModel magicLampsEntry = this.add(this.makeMagicLampsEntry(this.entryMap, 'l'));
        magicLampsEntry.withParent(BookEntryParentModel.create((ResourceLocation)iesnium.getId()));
        BookEntryModel spiritMinersEntry = this.add(this.makeSpiritMinersEntry(this.entryMap, 'M'));
        spiritMinersEntry.withParent(BookEntryParentModel.create((ResourceLocation)magicLampsEntry.getId()));
        BookEntryModel mineshaftEntry = this.add(this.makeMineshaftEntry(this.entryMap, 'D'));
        mineshaftEntry.withParent(BookEntryParentModel.create((ResourceLocation)spiritMinersEntry.getId()));
        BookEntryModel storageEntry = this.add(this.makeStorageEntry(this.entryMap, 's'));
        storageEntry.withParent(BookEntryParentModel.create((ResourceLocation)advancedChalksEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/craft_djinni")));
        BookEntryModel possessionRitualsEntry = this.add(this.makePossessionRitualsEntry(this.entryMap, 'w'));
        possessionRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/possess_foliot")));
        BookEntryModel familiarRitualsEntry = this.add(this.makeFamiliarRitualsEntry(this.entryMap, 'x'));
        familiarRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/possess_foliot")));
        BookEntryModel summoningRitualsEntry = this.add(this.makeSummoningRitualsEntry(this.entryMap, 'y'));
        summoningRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/summon_foliot")));
        BookEntryModel craftingRitualsEntry = this.add(this.makeCraftingRitualsEntry(this.entryMap, 'z'));
        craftingRitualsEntry.withParent(BookEntryParentModel.create((ResourceLocation)moreRitualsEntry.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(this.modLoc("pentacles/craft_foliot")));
    }

    protected String categoryName() {
        return "Getting Started";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create(OccultismItems.DICTIONARY_OF_SPIRITS_ICON);
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    private BookEntryModel makeIntroEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("intro");
        this.lang().add(this.context().entryName(), "About");
        this.lang().add(this.context().entryDescription(), "About using the Dictionary of Spirits");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "About");
        this.lang().add(this.context().pageText(), "This book aims to introduce the novice reader to the most common summoning rituals and equip them with a list of spirit names to summon.\nThe authors advise caution in the summoning of the listed entities and does not take responsibility for any harm caused.\n");
        this.context().page("help");
        BookTextPageModel help = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Getting Help");
        this.lang().add(this.context().pageText(), "If you run into any trouble while playing Occultism, please join our Discord server and ask for help.\n\\\n\\\n[Join us at https://discord.gg/trE4SHRXvb](https://discord.gg/trE4SHRXvb)\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS_ICON.get()).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro, help});
    }

    private BookEntryModel makeDemonsDreamEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("demons_dream");
        this.lang().add(this.context().entryName(), "Lifting the Veil");
        this.lang().add(this.context().entryDescription(), "Learn about the Otherworld and the Third Eye.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Otherworld");
        this.lang().add(this.context().pageText(), "Hidden from mere human eyes exists another plane of existence, another *dimension* if you will, the [#](%1$s)Otherworld[#]().\nThis world is populated with entities often referred to as [#](%1$s)Demons[#]().\n".formatted(COLOR_PURPLE));
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "These Demons possess a wide variety of powers and useful skills, and for centuries magicians have sought to summon them for their own gain.\nThe first step on the journey to successfully summoning such an Entity is to learn how to interact with the Otherworld.\n");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "%1$s is a herb that gives humans the [#](%2$s)Third Eye[#](),\nallowing them to see where the [#](%2$s)Otherworld[#]() intersects with our own.\nSeeds can be found **by breaking grass**.\n**Consuming** the grown fruit activates the ability *with a certain chance*.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("harvest_effect");
        BookTextPageModel harvestEffect = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An additional side effect of %1$s, is **the ability to interact with [#](%2$s)Otherworld[#]() materials**.\nThis is unique to %1$s, other ways to obtain [#](%2$s)Third Eye[#]() do not yield this ability.\nWhile under the effect of %1$s you are able to **harvest** Otherstone as well as Otherworld trees.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("datura_screenshot");
        BookImagePageModel datureScreenshot = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/datura_effect.png")});
        this.context().page("note_on_spirit_fire");
        BookTextPageModel spiritFire = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Hint**: The otherworld materials you obtain by harvesting under the effects of[#](%2$s)Third Eye[#]() **can be obtained more easily using [](item://occultism:spirit_fire)**. Proceed with the next entry in this book to learn more about spirit fire.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Multiple Demon's Dream fruits or seeds can be compressed into an essence that is much more potent. It *guarantees* the [#](%2$s)Third Eye[#]() and provides it for a longer amount of time, but comes with a lot of (positive and negative) side effects.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("recipe_essence");
        BookCraftingRecipePageModel recipeEssence = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/demons_dream_essence_from_fruit_or_seed"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Fruit and seeds can be mixed freely to create the essence.\n");
        this.context().page("spotlight3");
        BookSpotlightPageModel spotlight3 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The essence can be purified in spirit fire (more on that later!) to obtain a version free from all negative side effects, while retaining the positive.\n".formatted(DEMONS_DREAM, COLOR_PURPLE));
        this.context().page("recipe_essence_pure");
        BookSpiritFireRecipePageModel recipeEssencePure = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_essence"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DATURA.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, spotlight, harvestEffect, datureScreenshot, spiritFire, spotlight2, recipeEssence, spotlight3, recipeEssencePure});
    }

    private BookEntryModel makeSpiritFireEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirit_fire");
        this.lang().add(this.context().entryName(), "It burns!");
        this.lang().add(this.context().entryDescription(), "Or does it?");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_FIRE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[#](%1$s)Spiritfire[#]() is a special type of fire that exists mostly in [#](%1$s)The Other Place[#]()\nand does not harm living beings. Its special properties allow to use it to purify and convert\ncertain materials by burning them, without consuming them.\n".formatted(COLOR_PURPLE));
        this.context().page("spirit_fire_screenshot");
        BookImagePageModel spiritFireScreenshot = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/spiritfire_instructions.png")}).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Throw [](item://occultism:datura) to the ground and light it on fire with [](item://minecraft:flint_and_steel).\n");
        this.context().page("main_uses");
        BookTextPageModel mainUses = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The main uses of [](item://occultism:spirit_fire) are to convert [](item://minecraft:diamond) into [](item://occultism:spirit_attuned_gem),\nto get basic ingredients such as [](item://occultism:otherstone) and [Otherworld Saplings](item://occultism:otherworld_sapling_natural),\nand to purify impure chalks.\n");
        this.context().page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherstone"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An easier way to obtain [](item://occultism:otherstone) than via divination.\n");
        this.context().page("otherrock_recipe");
        BookSpiritFireRecipePageModel otherrockRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherrock"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Otherrock is a variation of [](item://occultism:otherstone),\n you can use it for decoration and making sacrificial bowls,\n  but it does not work as a base for chalks or dimensional storage.\n");
        this.context().page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An easier way to obtain [Otherworld Saplings](item://occultism:otherworld_sapling_natural) than via divination.\n");
        this.context().page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"));
        this.context().page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"));
        this.context().page("otherflower_recipe");
        BookSpiritFireRecipePageModel otherflowerRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherflower"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "An easier way to clone any dye, mix this flower and the target color. You can also make ~~suspicious~~ delicious stews.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.SPIRIT_FIRE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, spiritFireScreenshot, mainUses, otherstoneRecipe, otherrockRecipe, otherworldSaplingNaturalRecipe, otherworldAshesRecipe, gemRecipe, otherflowerRecipe});
    }

    private BookEntryModel makeHealingSpiritsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("healing_spirits");
        this.lang().add(this.context().entryName(), "Healing Spirits");
        this.lang().add(this.context().entryDescription(), "Fix up your spirit!");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DATURA.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Right-click a spirit with [](item://occultism:datura) to heal it.\n\\\n\\\nThis will work on **Familiars**, **Summoned Spirits** and also **Possessed Mobs**.\n");
        this.context().page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "When compressing Demon's Dream fruits or seeds into essence, a much stronger instant healing effect can be achieved. This comes at the cost of efficiency: Feeding 9 fruits to a spirit in succession will heal it more than feeding it 9 fruits worth of essence.\n");
        this.context().page("spotlight3");
        BookSpotlightPageModel spotlight3 = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Purifying the Demon's Dream Essence will yield a version that heals even more, negating the efficiency loss.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.SPLASH_POTION).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, spotlight2, spotlight3});
    }

    private BookEntryModel makeThirdEyeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("third_eye");
        this.lang().add(this.context().entryName(), "The Third Eye");
        this.lang().add(this.context().entryDescription(), "Do you see now?");
        this.context().page("about");
        BookTextPageModel about = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Third Eye");
        this.lang().add(this.context().pageText(), "The ability to see beyond the physical world is referred to as [#](%1$s)Third Eye[#]().\nHumans do not possess such an ability to see [#](%1$s)beyond the veil[#](),\nhowever with certain substances and contraptions the knowledgeable summoner can work around this limitation.\n".formatted(COLOR_PURPLE));
        this.context().page("how_to_obtain");
        BookTextPageModel howToObtain = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The most comfortable, and most *expensive*, way to obtain this ability, is to wear spectacles\ninfused with spirits, that *lend* their sight to the wearer.\nA slightly more nauseating, but **very affordable** alternative is the consumption of certain herbs,\n[%1$s](entry://occultism:dictionary_of_spirits/getting_started/demons_dream) most prominent among them.\n".formatted(DEMONS_DREAM));
        this.context().page("otherworld_goggles");
        BookSpotlightPageModel otherworldGoggles = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[These goggles](entry://occultism:dictionary_of_spirits/crafting_rituals/craft_otherworld_goggles) allow to see even more hidden Otherworld blocks,\nhowever they do not allow harvesting those materials.\nLow-tier materials can be harvested by consuming [%1$s](entry://occultism:dictionary_of_spirits/getting_started/demons_dream),\nbut more valuable materials require special tools.\n".formatted(DEMONS_DREAM));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/mob_effect/third_eye.png")).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{about, howToObtain, otherworldGoggles});
    }

    private BookEntryModel makeDivinationRodEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("divination_rod");
        this.lang().add(this.context().entryName(), "Divination Rod");
        this.lang().add(this.context().entryDescription(), "Obtaining otherworld materials");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Divination");
        this.lang().add(this.context().pageText(), "To make it easier to get started, the materials obtained by divination now also have crafting recipes.\n**If you want the full experience, skip the following recipe page and move on to the\n[divination instructions](entry://occultism:dictionary_of_spirits/getting_started/divination_rod@divination_instructions).**\n");
        this.context().page("otherstone_recipe");
        BookSpiritFireRecipePageModel otherstoneRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherstone"));
        this.context().page("otherworld_sapling_natural_recipe");
        BookSpiritFireRecipePageModel otherworldSaplingNaturalRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_sapling_natural"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Beware**: the tree growing from the sapling will look like a normal oak tree.\nYou need to activate the [Third Eye](entry://occultism:dictionary_of_spirits/getting_started/demons_dream)\nto harvest the Otherworld Logs and Leaves.\n");
        this.context().page("divination_rod");
        BookSpotlightPageModel divinationRod = (BookSpotlightPageModel)BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIVINATION_ROD.get()})).withText(this.context().pageText()).withAnchor("divination_instructions");
        this.lang().add(this.context().pageText(), "Otherworld materials play an important role in interacting with spirits.\nAs they are rare and not visible to the naked eye, finding them requires special tools.\nThe divination rod allows to find Otherworld materials based on their similarities to materials common to our world.\n");
        this.context().page("spirit_attuned_gem_recipe");
        BookSpiritFireRecipePageModel spiritAttunedGemRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"));
        this.context().page("divination_rod_recipe");
        BookCraftingRecipePageModel divinationRodRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/divination_rod"));
        this.context().page("about_divination_rod");
        BookTextPageModel aboutDivinationRod = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The divination rod uses a spirit attuned gem attached to a wooden rod.\nThe gem resonates with the chosen material, and this movement is amplified by the wooden rod,\nallowing to detect nearby Otherworld materials.    \n    \n    \nThe rod works by detecting resonance between real world and Otherworld materials.\nAttuned the rod to a real world material, and it will find the corresponding Otherworld block.\n");
        this.context().page("how_to_use");
        BookTextPageModel howToUse = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Use of the Rod");
        this.lang().add(this.context().pageText(), "[#](%1$s)Shift-right-click[#]() a block to attune the rod to the corresponding Otherworld block.\n- [](item://minecraft:andesite): [](item://occultism:otherstone)\n- [](item://minecraft:oak_wood):  [](item://occultism:otherworld_log)\n- [](item://minecraft:oak_leaves): [](item://occultism:otherworld_leaves)\n- [](item://minecraft:netherrack): [](item://occultism:iesnium_ore)\n\nThen [#](%1$s)right-click[#]() and hold until the rod animation finishes.".formatted(COLOR_PURPLE));
        this.context().page("how_to_use2");
        BookTextPageModel howToUse2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "After the animation finishes, the closest **found block will be highlighted\nwith white lines and can be seen through other blocks**.\nAdditionally you can watch the crystals for hints: a white crystal indicates no target blocks found,\na fully purple block means the found block is nearby. Mixes between white and purple show\nthat the target is rather far away.");
        this.context().page("how_to_use3");
        BookTextPageModel howToUse3 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "[#](%1$s)Right-clicking[#]() without holding after a successful search will show the last found target block again.\n\\\n\\\nIf the mod *\"Theurgy\"* is installed the rod will not highlight the target block, but instead send a particle effect in the direction of the target block.\n".formatted(COLOR_PURPLE));
        this.context().page("divination_rod_screenshots");
        BookImagePageModel divinationRodScreenshots = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/rod_far.png"), this.modLoc("textures/gui/book/rod_mid.png"), this.modLoc("textures/gui/book/rod_near.png")}).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "White means nothing was found.\nThe more purple you see, the closer you are.\n");
        this.context().page("troubleshooting");
        BookTextPageModel troubleshooting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Troubleshooting");
        this.lang().add(this.context().pageText(), "If the rod does not create highlighted blocks for you, you can try to:\n- If you have theurgy mod installed, then a particle effect will be used instead, set the particles to all or decreased in the video settings\n- Open occultism-client.toml in your instance's /config folder and set useAlternativeDivinationRodRenderer = true\n");
        this.context().page("otherworld_groves");
        BookTextPageModel otherworldGroves = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Otherworld Groves");
        this.lang().add(this.context().pageText(), "Otherworld Groves are lush, overgrown caves, with [#](%1$s)Otherworld Trees[#](),\nand walls of [](item://occultism:otherstone), and represent the fastest way to get everything one\nneeds to get set up as a summoner.\nTo find them, attune your divination rod to Otherworld leaves\nor logs, as unlike Otherstone, they only spawn in these groves.\n".formatted(COLOR_PURPLE));
        this.context().page("otherworld_groves_2");
        BookTextPageModel otherworldGroves2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Hint:** In the Overworld, look **down**.\n");
        this.context().page("otherworld_trees");
        BookTextPageModel otherworldTrees = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Otherworld Trees");
        this.lang().add(this.context().pageText(), "Otherworld trees grow naturally in Otherworld Groves. To the naked eye they appear as oak trees,\nbut to the Third Eye they reveal their true nature.    \n**Important:** Otherworld Saplings can only be obtained by breaking the leaves manually, naturally only oak saplings drop.\n");
        this.context().page("otherworld_trees_2");
        BookTextPageModel otherworldTrees2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Trees grown from Stable Otherworld Saplings as obtained from spirit traders do not have that limitation.\n");
        this.context().page("config");
        BookTextPageModel config = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Extra Config");
        this.lang().add(this.context().pageText(), "An additional function of the Divination Rod is to locate any ore,\n however this is not a default function and needs to be enabled,\n as we recommend using the Greedy familiar or Theurgy mod for this type of divination.\n If you want to enable this feature directly in Occultism Divination Rod, check\n \"Server Configuration > Items\" and set \"Divination c:ores\" to \"on\".\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.DIVINATION_ROD.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, otherstoneRecipe, otherworldSaplingNaturalRecipe, divinationRod, spiritAttunedGemRecipe, divinationRodRecipe, aboutDivinationRod, howToUse, howToUse2, howToUse3, divinationRodScreenshots, troubleshooting, otherworldGroves, otherworldGroves2, otherworldTrees, otherworldTrees2, config});
    }

    private BookEntryModel makeTheurgyDivinationRodsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("theurgy_divination_rod");
        this.lang().add(this.context().entryName(), "More Divination Rods");
        this.lang().add(this.context().entryDescription(), "Finding other ores and resources.");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "While the [](item://occultism:divination_rod) is a great tool for finding [#](%1$s)Otherworld Materials[#](), it would be useful to have a way to find *all other* ores and resources as well.\n\\\n\\\nThis is where the Theurgy Divination Rod comes in.\n".formatted(COLOR_PURPLE));
        this.context().page("recipe_rod");
        BookCraftingRecipePageModel recipeRod = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1("theurgy:crafting/shaped/divination_rod_t1");
        this.context().page("more_info");
        BookTextPageModel moreInfo = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find out more about the Theurgy Divination Rod, check out *\"The Hermetica\"*, the Guidebook for Theurgy.\n[This Entry](entry://theurgy:the_hermetica/getting_started/about_divination_rods) has more information about the Theurgy Divination Rod.\n");
        this.context().page("recipe_hermetica");
        BookCraftingRecipePageModel recipeHermetica = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1("theurgy:crafting/shapeless/the_hermetica");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)ItemRegistry.DIVINATION_ROD_T1.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, recipeRod, moreInfo, recipeHermetica});
    }

    private BookEntryModel makeCandleEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("candle");
        this.lang().add(this.context().entryName(), "Candles");
        this.lang().add(this.context().entryDescription(), "Let there be light!");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.LARGE_CANDLE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Candles provide stability to rituals and are an important part of almost all pentacles.\n**Large Candles also act like bookshelves for enchantment purposes.**\n\\\n\\\nCandles from Minecraft and other Mods may be used in place of Occultism candles.\n");
        this.context().page("tallow");
        BookSpotlightPageModel tallow = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.TALLOW.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Key ingredient for large candles. Kill large animals like pigs, cows or sheep with a [](item://occultism:butcher_knife)\nto harvest [](item://occultism:tallow).\n");
        this.context().page("cleaver_recipe");
        BookCraftingRecipePageModel cleaverRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/butcher_knife"));
        this.context().page("candle_recipe");
        BookCraftingRecipePageModel candleRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/large_candle"));
        this.context().page("color_candle");
        BookTextPageModel colorCandle = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "You can use a dye and the [](item://occultism:large_candle) to mix then in shapeless craft process to get a colored large candle.\n\\\nAvailable in all the 16 minecraft dyes.\n");
        this.context().page("lit_candle");
        BookTextPageModel litCandle = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Just like the candles from Minecraft, [](item://occultism:large_candle) and colored versions can be lit, turning in a great light source.\n\\\nIn addition, you can use a [](item://minecraft:torch), [](item://minecraft:soul_torch), [](item://minecraft:redstone_torch) or [](item://occultism:spirit_torch) to change the type of fire.\n\\\nAlso can be waterlogged.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.LARGE_CANDLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, tallow, cleaverRecipe, candleRecipe, colorCandle, litCandle});
    }

    private BookEntryModel makeRitualPrepChalkEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("ritual_prep_chalk");
        this.lang().add(this.context().entryName(), "Ritual Preparations: Chalks");
        this.lang().add(this.context().entryDescription(), "Signs to find them, Signs to bring them all, and in the darkness bind them.");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual Preparations: Chalks");
        this.lang().add(this.context().pageText(), "To summon spirits from the [#](%1$s)Other Place[#]() in *relative* safety,\nyou need to draw a fitting pentacle using chalk to contain their powers.\n".formatted(COLOR_PURPLE));
        this.context().page("white_chalk");
        BookSpotlightPageModel whiteChalkSpotlight = (BookSpotlightPageModel)BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE.get()})).withText(this.context().pageText()).withAnchor("white_chalk");
        this.lang().add(this.context().pageText(), "White chalk is used to draw the most basic pentacles, such as for our first ritual.\n\\\n\\\nMore powerful summonings require appropriate more advanced chalk, see [Chalks](entry://occultism:dictionary_of_spirits/getting_started/chalks) for more information.\n");
        this.context().page("burnt_otherstone_recipe");
        BookSmeltingRecipePageModel burntOtherstoneRecipe = (BookSmeltingRecipePageModel)BookSmeltingRecipePageModel.create().withRecipeId1(this.modLoc("smelting/burnt_otherstone"));
        this.context().page("otherworld_ashes_recipe");
        BookSpiritFireRecipePageModel otherworldAshesRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_ashes"));
        this.context().page("impure_white_chalk_recipe");
        BookCraftingRecipePageModel impureWhiteChalkRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/chalk_white_impure"));
        this.context().page("white_chalk_recipe");
        BookSpiritFireRecipePageModel whiteChalkRecipe = (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/chalk_white"));
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "Right-click on a block with the chalk to draw a single glyph. For decorative purposes you can repeatedly click a block to cycle through glyphs. The shown glyph does not matter for the ritual, only the color.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.CHALK_WHITE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, whiteChalkSpotlight, burntOtherstoneRecipe, otherworldAshesRecipe, impureWhiteChalkRecipe, whiteChalkRecipe, usage});
    }

    private BookEntryModel makeRitualPrepBowlEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("ritual_prep_bowl");
        this.lang().add(this.context().entryName(), "Ritual Preparations: Sacrificial Bowls");
        this.lang().add(this.context().entryDescription(), "There is no power without sacrifice.");
        this.context().page("sacrificial_bowl");
        BookSpotlightPageModel sacrificialBowlSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual Preparations: Sacrificial Bowls");
        this.lang().add(this.context().pageText(), "These bowls are used to place the items we will sacrifice as part of a ritual and you will need a handful of them.\nNote: Their exact placement in the ritual does not matter - just keep them within 8 blocks horizontally of the pentacle center!\n");
        this.context().page("sacrificial_bowl_recipe");
        BookCraftingRecipePageModel sacrificialBowlRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/sacrificial_bowl"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "You can mix a sacrificial bowl with a copper or silver ingot to create variations with the same functionality.\n");
        this.context().page("decorative_sacrificial_bowl_recipe");
        BookCraftingRecipePageModel decorativeSacrificialBowlRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/copper_sacrificial_bowl"))).withRecipeId2(this.modLoc("crafting/silver_sacrificial_bowl"));
        this.context().page("spirit_bowl");
        BookSpotlightPageModel spiritBowlSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_FIRE.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Bowls and Spirit Fire");
        this.lang().add(this.context().pageText(), "If you place a sacrificial bowl above a Spirit Fire or Spirit Campfire,\nany item inserted will instantly transform if it has a recipe in the spirit fire.\\\nAlso work with copper or silver version of sacrificial bowl.\n");
        this.context().page("golden_sacrificial_bowl");
        BookSpotlightPageModel goldenSacrificialBowlSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Once everything has been set up and you are ready to start, this special sacrificial bowl is used to activate the ritual by [#](%1$s)right-clicking[#]() it with the activation item,\nusually a [Book of Binding](entry://getting_started/books_of_binding).\n".formatted(COLOR_PURPLE));
        this.context().page("golden_sacrificial_bowl_recipe");
        BookCraftingRecipePageModel goldenSacrificialBowlRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/golden_sacrificial_bowl"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{sacrificialBowlSpotlight, sacrificialBowlRecipe, decorativeSacrificialBowlRecipe, spiritBowlSpotlight, goldenSacrificialBowlSpotlight, goldenSacrificialBowlRecipe});
    }

    private BookEntryModel makeBooksOfBindingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("books_of_binding");
        this.lang().add(this.context().entryName(), "Books of Binding");
        this.lang().add(this.context().entryDescription(), "Or how to identify your spirit");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Books of Binding");
        this.lang().add(this.context().pageText(), "To call forth a spirit, a [#](%1$s)Book of Binding[#]() must be used in the ritual.\nThere is a type of book corresponding to each type (or tier) of spirit.\nTo identify a spirit to summon, it's name must be written in the [#](%1$s)Book of Binding[#](), resulting in a [#](%1$s)Bound Book of Binding[#]() that can be used in the ritual.\n".formatted(COLOR_PURPLE));
        this.context().page("intro2");
        BookTextPageModel intro2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "**Note:** *The spirit names are eye candy only*, that means they are not relevant for the recipe. As long as you have the right spirit type in your book of binding it can be used.\n".formatted(COLOR_PURPLE));
        this.context().page("purified_ink_recipe");
        BookSpiritFireRecipePageModel purifiedInkRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/purified_ink"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In order to craft [#](%1$s)Books of Binding[#]() to summon spirits, you need purified ink. Simply drop any black dye into [](item://occultism:spirit_fire) to purify it.\n".formatted(COLOR_PURPLE));
        this.context().page("awakened_feather_recipe");
        BookSpiritFireRecipePageModel awakenedFeatherRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/awakened_feather"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "In order to craft [#](%1$s)Books of Binding[#]() to summon spirits, you also need awakened feather. Simply drop any feather into [](item://occultism:spirit_fire) to awakened it.\n".formatted(COLOR_PURPLE));
        this.context().page("taboo_book_recipe");
        BookSpiritFireRecipePageModel tabooBookRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/taboo_book"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Lastly you need taboo book to craft [#](%1$s)Books of Binding[#]() to summon spirits. Simply drop a book into [](item://occultism:spirit_fire) to get it.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_foliot_recipe");
        BookCraftingRecipePageModel bookOfBindingFoliotRecipe = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_foliot"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Craft a book of binding that will be used to call forth a [#](%1$s)Foliot[#]() spirit.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_bound_foliot_recipe");
        BookBindingCraftingRecipePageModel bookOfBindingBoundFoliotRecipe = (BookBindingCraftingRecipePageModel)BookBindingCraftingRecipePageModel.create().withRecipeId1().withUnboundBook(OccultismItems.BOOK_OF_BINDING_FOLIOT.toStack()).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Add the name of the spirit to summon to your book of binding by crafting it with the Dictionary of Spirits. The Dictionary will not be used up.\n");
        this.context().page("book_of_binding_djinni_recipe");
        BookCraftingRecipePageModel bookOfBindingDjinniRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_djinni"));
        this.context().page("book_of_binding_bound_djinni_recipe");
        BookBindingCraftingRecipePageModel bookOfBoundBindingDjinniRecipe = BookBindingCraftingRecipePageModel.create().withRecipeId1().withUnboundBook(OccultismItems.BOOK_OF_BINDING_DJINNI.toStack());
        this.context().page("book_of_binding_afrit_recipe");
        BookCraftingRecipePageModel bookOfBindingAfritRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_afrit"));
        this.context().page("book_of_binding_bound_afrit_recipe");
        BookBindingCraftingRecipePageModel bookOfBoundBindingAfritRecipe = BookBindingCraftingRecipePageModel.create().withRecipeId1().withUnboundBook(OccultismItems.BOOK_OF_BINDING_AFRIT.toStack());
        this.context().page("book_of_binding_marid_recipe");
        BookCraftingRecipePageModel bookOfBindingMaridRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_binding_marid"));
        this.context().page("book_of_binding_bound_marid_recipe");
        BookBindingCraftingRecipePageModel bookOfBoundBindingMaridRecipe = BookBindingCraftingRecipePageModel.create().withRecipeId1().withUnboundBook(OccultismItems.BOOK_OF_BINDING_MARID.toStack());
        this.context().page("book_of_binding_empty");
        BookSpiritFireRecipePageModel alternativeBooks = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/book_of_binding_empty"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), " Alternatively, you can directly use the Binding Book: Empty instead of the previous three items. There are two ways to obtain this book. Place this book in the center of dyes to get specific book of binding.\n".formatted(COLOR_PURPLE));
        this.context().page("book_of_binding_empty_recipe");
        BookCraftingRecipePageModel bookOfBindingEmptyRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId2(this.modLoc("crafting/book_of_binding_empty"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, intro2, purifiedInkRecipe, awakenedFeatherRecipe, tabooBookRecipe, bookOfBindingFoliotRecipe, bookOfBindingBoundFoliotRecipe, bookOfBindingDjinniRecipe, bookOfBoundBindingDjinniRecipe, bookOfBindingAfritRecipe, bookOfBoundBindingAfritRecipe, bookOfBindingMaridRecipe, bookOfBoundBindingMaridRecipe, alternativeBooks, bookOfBindingEmptyRecipe});
    }

    private BookEntryModel makeBooksOfBindingAutomationEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("books_of_binding_automation");
        this.lang().add(this.context().entryName(), "Books of Binding in Automation");
        this.lang().add(this.context().entryDescription(), "Tips for using books of binding in Crafting Automation such as AE2 or RS");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Problem");
        this.lang().add(this.context().pageText(), "Bound Books of Binding are generated with a random spirit name. This tricks many automated crafting processes into no longer recognizing the item as the requested crafting result, because it does not expect NBT/Data Components on the item.\n\\\n\\\nThis leads to stuck crafting processes.\n");
        this.context().page("solution");
        BookTextPageModel solution = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Solution");
        this.lang().add(this.context().pageText(), "1. Put a dictionary of spirits into an anvil and give it a name. This will be the name of all spirits summoned in the future.\n2. Use this dictionary to configure crafting patterns (if your automation mod requires it).\n3. Use this dictionary to craft the Bound Books of Binding in the automation system. As usual, the dictionary will not be used up.\n4. All crafted books will now have the same name and will be recognized by your automation system.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.CRAFTER).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, solution});
    }

    private BookEntryModel makeBooksOfCallingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("books_of_calling");
        this.lang().add(this.context().entryName(), "Books of Calling");
        this.lang().add(this.context().entryDescription(), "Telling your spirits what to do");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Books of Calling");
        this.lang().add(this.context().pageText(), "Books of Calling allow to control a summoned spirit, and to store it to prevent essence decay or move it more easily.\n\\\n\\\nOnly spirits that require precise instructions - such as a work area or drop-off storage - come with a book of calling.\n");
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Usage");
        this.lang().add(this.context().pageText(), "- [#](%1$s)Right-click[#]() air to open the configuration screen\n- [#](%1$s)Shift-right-click[#]() a block to apply the action selected in the configuration screen\n- [#](%1$s)Shift-right-click[#]() a spirit to capture it (must be of the same type)\n- [#](%1$s)Right-click[#]() with a book with a captured spirit to release it\n".formatted(COLOR_PURPLE));
        this.context().page("obtaining");
        BookTextPageModel obtaining = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "How to obtain Books of Calling");
        this.lang().add(this.context().pageText(), "If a summoned spirit supports the use of a Book of Calling, the summoning ritual will automatically spawn a book in the world alongside the spirit.\n\\\n\\\nIf you **lose the book**, there are also crafting recipes that just provide the book (without summoning a spirit).\n".formatted(COLOR_PURPLE));
        this.context().page("obtaining2");
        BookTextPageModel obtaining2 = BookTextPageModel.create().withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The recipes can be found in this book or via JEI.\n\\\n\\\n[#](%1$s)Shift-right-click[#]() the spirit with the crafted book to assign it.\n".formatted(COLOR_PURPLE));
        this.context().page("storage");
        BookTextPageModel storage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Storing Spirits");
        this.lang().add(this.context().pageText(), "To store spirits that do not have a fitting book of calling, you can use a [Soul Gem](entry://crafting_rituals/craft_soul_gem).\nSoul gems are much more versatile and allow to store almost all types of entities even animals and monsters, but not players or bosses.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, usage, obtaining, obtaining2, storage});
    }

    private BookEntryModel makeRitualEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("first_ritual");
        this.lang().add(this.context().entryName(), "First Ritual");
        this.lang().add(this.context().entryDescription(), "We're actually getting started now!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "The Ritual (tm)");
        this.lang().add(this.context().pageText(), "These pages will walk the gentle reader through the process of the [first ritual](entry://summoning_rituals/summon_crusher_t1) step by step.\n\\\nWe **start** by placing the [](item://occultism:golden_sacrificial_bowl) and drawing the appropriate pentacle, [Aviar's Circle](entry://pentacles/summon_foliot) as seen on the left around it.\n".formatted(COLOR_PURPLE));
        this.context().page("multiblock");
        BookMultiblockPageModel multiblock = BookMultiblockPageModel.create().withMultiblockId(this.modLoc("summon_foliot")).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Only the color and location of the chalk marks is relevant, not the glyph/sign.\n".formatted(COLOR_PURPLE));
        this.context().page("bowl_text");
        BookTextPageModel bowlText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Sacrificial Bowls");
        this.lang().add(this.context().pageText(), "Next, place *at least* 4 [Sacrificial Bowls](item://occultism:sacrificial_bowl) close to the pentacle.\n\\\n\\\nThey must be placed **anywhere** within 8 blocks of the central [](item://occultism:golden_sacrificial_bowl). **The exact location does not matter.**\n".formatted(COLOR_PURPLE));
        this.context().page("bowl_placement");
        BookImagePageModel bowlPlacementImage = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/bowl_placement.png")}).withBorder(true).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Possible locations for the sacrificial bowls.\n".formatted(COLOR_PURPLE));
        this.context().page("ritual_text");
        BookTextPageModel ritualText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Placing Ingredients");
        this.lang().add(this.context().pageText(), "Now it is time to place the ingredients you see on the next page in the (regular, not golden) sacrificial bowls. The ingredients will be consumed from the bowls as the ritual progresses.\n".formatted(COLOR_PURPLE));
        this.context().page("ritual_recipe");
        BookRitualRecipePageModel ritualRecipe = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_crusher"));
        this.context().page("pentacle_link_hint");
        BookTextPageModel pentacleLinkHint = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "A Note about Ritual Recipes");
        this.lang().add(this.context().pageText(), "Ritual recipe pages, such as the previous pageshow not only the ingredients, but also the pentacle that you need to draw with chalk in order to use the ritual.\n\\\n\\\n**To show the pentacle, click the blue link** at the center top of the ritual page. You can then even preview it in-world.\n".formatted(COLOR_PURPLE));
        this.context().page("start_ritual");
        BookTextPageModel startRitualText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Let there be ... spirits!");
        this.lang().add(this.context().pageText(), "Finally, [#](%1$s)right-click[#]() the [](item://occultism:golden_sacrificial_bowl) with the **bound** book of binding you created before and wait until the crusher spawns.\n\\\n\\\nNow all that remains is to drop appropriate ores near the crusher and wait for it to turn it into dust.\n".formatted(COLOR_PURPLE));
        this.context().page("automation");
        BookTextPageModel automationText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Automatic Rituals");
        this.lang().add(this.context().pageText(), "Instead of right-clicking the golden sacrificial bowl with the final ingredient, you can also use a Hopper or any type of pipe to insert the item into the bowl. The ritual will start automatically.\\\nNote that any rituals that summon tamed animals or familiars will summon them untamed instead.\n".formatted(COLOR_PURPLE));
        this.context().page("upside_down_bowl");
        BookTextPageModel upsideDownBowlText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Don't let my items drop");
        this.lang().add(this.context().pageText(), "If you want to hold crafted items instead of dropping them into the world, place a sacrificial bowl facing down above the golden one.\nThis works up to three blocks higher and can also be used with a copper or silver sacrificial bowl.\n".formatted(COLOR_PURPLE));
        this.context().page("automation_flame");
        BookSpotlightPageModel automationFlameText = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.FLAME_AUTOMATION.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The setup of upside-down bowl, also produce [](item://occultism:flame_of_automation) when the ritual don't has an item as output.\nFor example, this can be used to automate spirit summoning and possessing, as a return to your system (it will come with the NBT of the ritual performed).\n".formatted(COLOR_PURPLE));
        this.context().page("redstone");
        BookTextPageModel redstoneText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Redstone");
        this.lang().add(this.context().pageText(), "Depending on the ritual state the golden bowl will emit a different redstone level:\n- **0** if no ritual is active\n- **1** if the ritual is active, but waiting for a sacrifice\n- **2** if the ritual is active, but waiting for an item to be used\n- **8** if the ritual is active and running\n".formatted(COLOR_PURPLE));
        this.context().page("clone_redstone");
        BookTextPageModel cloneRedstoneText = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "All sides blocked?");
        this.lang().add(this.context().pageText(), "You can place another [](item://occultism:golden_sacrificial_bowl) in the third block below the\n original [](item://occultism:golden_sacrificial_bowl). Every time this new bowl receives an\n block update, it clones the actual signal strength of the original bowl.\n".formatted(COLOR_PURPLE));
        this.context().page("clone_placement");
        BookImagePageModel clonePlacementImage = BookImagePageModel.create().withImages(new ResourceLocation[]{this.modLoc("textures/gui/book/redstone_clone.png")}).withBorder(true).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "One suggestion is to use any block that interacts with redstone and an observer.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.PENTACLE_SUMMON.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, multiblock, bowlText, bowlPlacementImage, ritualText, ritualRecipe, pentacleLinkHint, startRitualText, automationText, upsideDownBowlText, automationFlameText, redstoneText, cloneRedstoneText, clonePlacementImage});
    }

    private BookEntryModel makeBrushEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("brush");
        this.lang().add(this.context().entryName(), "Brush");
        this.lang().add(this.context().entryDescription(), "Cleaning up!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Next Steps");
        this.lang().add(this.context().pageText(), "Chalk is a pain to clean up, by [#](%1$s)right-clicking[#]() with a brush you can remove it from the world much more easily.\n".formatted(COLOR_PURPLE));
        this.context().page("brushRecipe");
        BookCraftingRecipePageModel brushRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/brush"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.BRUSH.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, brushRecipe});
    }

    private BookEntryModel makeMoreRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("more_rituals");
        this.lang().add(this.context().entryName(), "More Rituals");
        this.lang().add(this.context().entryDescription(), "Ready for new challenges?");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/robe.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("rituals"));
    }

    private BookEntryModel makeGreyParticlesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("grey_particles");
        this.lang().add(this.context().entryName(), "Grey particles?");
        this.lang().add(this.context().entryDescription(), "What to do when a ritual seems stuck!");
        this.context().page("text");
        BookTextPageModel text = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Ritual stuck?");
        this.lang().add(this.context().pageText(), "If a ritual appears stuck - no items being consumed - you should see grey particles around the [](item://occultism:golden_sacrificial_bowl). If this is the case the ritual requires you to either [use a specific item](entry://rituals/item_use) or [sacrifice a specific mob](entry://rituals/sacrifice).\n\\\n\\\nFind the ritual in the [Rituals](category://rituals) category and check for instructions.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)Items.GRAY_DYE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{text});
    }

    private BookEntryModel makeSpiritsSubcategoryEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirits");
        this.lang().add(this.context().entryName(), "About Spirits");
        this.lang().add(this.context().entryDescription(), "Learn more about Spirits.");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/spirits.png")).withCategoryToOpen(this.modLoc("spirits")).withEntryBackground(1, 1).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeChalksEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("chalks");
        this.lang().add(this.context().entryName(), "More Chalks");
        this.lang().add(this.context().entryDescription(), "Better chalks for better rituals!");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Chalks");
        this.lang().add(this.context().pageText(), "For more advanced rituals the basic [White Chalk](entry://occultism:dictionary_of_spirits/getting_started/ritual_prep_chalk) is not sufficient. Instead chalks made from more arcane materials are required.\n");
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Pentacle Category");
        this.lang().add(this.context().pageText(), "Follow the progression in [Pentacle page](category://pentacles) to get the 16 chalks and do all pentacles,\n");
        this.context().page("fire");
        BookTextPageModel fire = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Colored Spirit Fire");
        this.lang().add(this.context().pageText(), "Right-clicking on Spirit Fire with a Chalk will change the color of the flames.\\\n\\\nDye dye dye, its muffin time.\n");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.CHALK_YELLOW.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, more, fire});
    }

    private BookEntryModel makeOtherworldGogglesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("otherworld_goggles");
        this.lang().add(this.context().entryName(), "Otherworld Goggles");
        this.lang().add(this.context().entryDescription(), "Say no to drugs!");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "The [](item://occultism:otherworld_goggles) are what advanced summoners use to see the [#](%1$s)Otherworld[#](), to avoid the negative side effects of [](entry://occultism:dictionary_of_spirits/getting_started/demons_dream).\n\\\n\\\nMaking your first pair of these is seen by many as a rite of passage.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting Goggles");
        this.lang().add(this.context().pageText(), "Crafting these goggles is a multi-step process described in detail in the Entry about [Crafting Otherworld Goggles](entry://crafting_rituals/craft_otherworld_goggles).\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeInfusedPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("infused_pickaxe");
        this.lang().add(this.context().entryName(), "Infused Pickaxe");
        this.lang().add(this.context().entryDescription(), "Tackling Otherworld Ores");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Beyond [](item://occultism:otherworld_log) and [](item://occultism:otherstone) there are also otherworld materials that require special tools to harvest.\n\\\n\\\nThis pickaxe is rather brittle, but it will do the job.\n");
        this.context().page("gem_recipe");
        BookSpiritFireRecipePageModel gemRecipe = (BookSpiritFireRecipePageModel)((BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/spirit_attuned_gem"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "These gems, when infused with a spirit, can be used to interact with Otherword materials and are the key to crafting the pickaxe.\n");
        this.context().page("head_recipe");
        BookCraftingRecipePageModel headRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/spirit_attuned_pickaxe_head"));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "After preparing the raw materials, the pickaxe needs to be infused with a spirit.\n\\\n\\\nFollow the instructions at [Craft Infuse Pickaxe](entry://crafting_rituals/craft_infused_pickaxe)\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.INFUSED_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, gemRecipe, headRecipe, crafting});
    }

    private BookEntryModel makeIesniumEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("iesnium");
        this.lang().add(this.context().entryName(), "Iesnium Ore");
        this.lang().add(this.context().entryDescription(), "Myterious metals ...");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.IESNIUM_ORE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "This is a rare metal that, to the naked eye, looks like [](item://minecraft:netherrack) and cannot be mined with a regular pickaxe.\n\\\n\\\nWhen mined with the correct tools, it can be used to craft powerful items (you will learn more about that later).\n".formatted(COLOR_PURPLE));
        this.context().page("where");
        BookTextPageModel where = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Where to find it");
        this.lang().add(this.context().pageText(), "Like Netherrack, Iesnium can be found in the Nether. In order to **see** it, you need to wear [Otherworld Goggles](entry://getting_started/otherworld_goggles).\n\\\n\\\nTo make searching for it simpler, attune a [Divination Rod](entry://getting_started/divination_rod) to it and righ-click and hold in the nether until it highlights a nearby block, which will hold the ore.\n".formatted(COLOR_PURPLE));
        this.context().page("how");
        BookTextPageModel how = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "How to mine it");
        this.lang().add(this.context().pageText(), "Iesnium can only be mined with the [Infused Pickaxe](entry://getting_started/infused_pickaxe) or an [](item://occultism:iesnium_pickaxe) (about which you will learn later).\n\\\n\\\nAfter identifying a block that holds Iesnium, you can mine it with the pickaxe you created in the previous step.\n".formatted(COLOR_PURPLE));
        this.context().page("processing");
        BookTextPageModel processing = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Processing");
        this.lang().add(this.context().pageText(), "Iesnium Ore, after mining, can be smelted directly into ingots, or placed down. When placed, it will not turn back into it's netherrack form. Consequently it can also be mined with any pickaxe then. This visible form of the Ore, when mined, will drop [](item://occultism:raw_iesnium).\n".formatted(COLOR_PURPLE));
        this.context().page("uses");
        BookTextPageModel uses = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Uses");
        this.lang().add(this.context().pageText(), "Iesnium can be used to craft an improved pickaxe, spirit lamps, and other powerful items. Follow the progress in this book to learn more about it.\n".formatted(COLOR_PURPLE));
        this.context().page("otherglass");
        BookCraftingRecipePageModel otherglass = (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/otherglass"))).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "One of the uses of iesnium is the creation of Otherglass, this block hides from common eyes and is revealed only to those who see the other world. To collect this you need an infused or iesnium pickaxe.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.IESNIUM_ORE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, where, how, processing, uses, otherglass});
    }

    private BookEntryModel makeIesniumPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("iesnium_pickaxe");
        this.lang().add(this.context().entryName(), "Iesnium Pickaxe");
        this.lang().add(this.context().entryDescription(), "A more durable otherworld-appropriate pickaxe");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "Like the [Infused Pickaxe](entry://getting_started/infused_pickaxe), this pickaxe can be used to mine Tier 2 Otherworld Materials such as [](item://occultism:iesnium_ore). As it is made from metal, instead of brittle [](item://occultism:spirit_attuned_gem), it is very durable and can be used for a long time.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookCraftingRecipePageModel crafting = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/iesnium_pickaxe"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.IESNIUM_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeMagicLampsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("magic_lamps");
        this.lang().add(this.context().entryName(), "Magic Lamps");
        this.lang().add(this.context().entryDescription(), "Three wishes? Close, but not quite..");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Magic Lamps");
        this.lang().add(this.context().pageText(), "Magic Lamps can be used to keep spirits safe from [#](%1$s)Essence Decay[#](), while still having access to some of their powers. Most commonly they are used to access a [#](%1$s)Mining Dimension[#]() and act as (*lag free*) [#](%1$s)Void Miners[#]().\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookCraftingRecipePageModel crafting = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeSpiritMinersEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("spirit_miners");
        this.lang().add(this.context().entryName(), "Spirit Miners");
        this.lang().add(this.context().entryDescription(), "It's Free Real Estate (-> Resources)");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Spirit Miners");
        this.lang().add(this.context().pageText(), "By summoning a spirit into a Magic Lamp and placing it in a [Dimensional Mineshaft (see next step)](entry://getting_started/mineshaft) it can be made to mine for you in a [#](%1$s)Mining Dimension[#](). This is a great way to get resources without having to go mining in the overworld (or other dimesions) yourself.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "See [Foliot Miner](entry://crafting_rituals/craft_foliot_miner) and the subsequent entries for information on how to craft spirit miners.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeMineshaftEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("mineshaft");
        this.lang().add(this.context().entryName(), "Dimensional Mineshaft");
        this.lang().add(this.context().entryDescription(), "Ethically questionable, but very profitable");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(this.context().pageText());
        this.lang().add(this.context().pageText(), "This block acts as a portal, for spirits only, to the [#](%1$s)Mining Dimension[#](). Place a Magic Lamp with a Miner Spirit in it, to make it mine for you.\n".formatted(COLOR_PURPLE));
        this.context().page("crafting");
        BookTextPageModel crafting = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Crafting");
        this.lang().add(this.context().pageText(), "See [Dimensional Mineshaft](entry://crafting_rituals/craft_dimensional_mineshaft) in the [Binding Rituals](category://crafting_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, crafting});
    }

    private BookEntryModel makeStorageEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("storage");
        this.lang().add(this.context().entryName(), "Magic Storage");
        this.lang().add(this.context().entryDescription(), "Looking for much much much more storage? Look no further!");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withCategoryToOpen(this.modLoc("storage"));
    }

    private BookEntryModel makePossessionRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("possession_rituals");
        this.lang().add(this.context().entryName(), "Possession Rituals");
        this.lang().add(this.context().entryDescription(), "A different way to get rare drops ...");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Possession Rituals");
        this.lang().add(this.context().pageText(), "Possessed mobs are controlled by spirits, allowing the summoner to determine some of their properties. They usually have **high drop rates** for rare drops, but are generally harder to kill.\n\\\n\\\nYou probably will want to start by summoning a [Possessed Endermite](entry://possession_rituals/possess_endermite) to get [](item://minecraft:end_stone) to craft [Advanced Chalks](entry://getting_started/chalks).\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find out more about Possession Rituals, see the [Possession Rituals](category://possession_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/possession.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeFamiliarRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("familiar_rituals");
        this.lang().add(this.context().entryName(), "Familiar Rituals");
        this.lang().add(this.context().entryDescription(), "Personal helpers that provide buffs or fight for you");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Familiar Rituals");
        this.lang().add(this.context().pageText(), "Familiars provide a variety of bonus effects, such as feather falling, water breathing, jump boosts and more, and may also assist you in combat.\n\\\n\\\nStore them in a [Familiar Ring](entry://crafting_rituals/craft_familiar_ring) to equip them as a curio.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Familiars, see the [Familiar Rituals](category://familiar_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/familiar.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeSummoningRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("summoning_rituals");
        this.lang().add(this.context().entryName(), "Summoning Rituals");
        this.lang().add(this.context().entryDescription(), "Spirit helpers for your daily work life");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Summoning Rituals");
        this.lang().add(this.context().pageText(), "Summoning Rituals allow you to summon spirits to work for you. Unlike familiars, they are not personally bound to you, meaning they will not follow you around, but they will perform various work tasks for you. In fact the first ritual you performed, the [Foliot Crusher](entry://getting_started/first_ritual), was a summoning ritual.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Summoning Rituals, see the [Summoning Rituals](category://summoning_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/summoning.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }

    private BookEntryModel makeCraftingRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("crafting_rituals");
        this.lang().add(this.context().entryName(), "Infusion Rituals");
        this.lang().add(this.context().entryDescription(), "Infuse spirits into items to create powerful tools");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "Infusion Rituals");
        this.lang().add(this.context().pageText(), "Infusion rituals are all about crafting powerful items, by binding (\"infusing\") spirits into objects.The spirits will provide special functionality to the items.\n".formatted(COLOR_PURPLE));
        this.context().page("more");
        BookTextPageModel more = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.lang().add(this.context().pageTitle(), "More Information");
        this.lang().add(this.context().pageText(), "To find more about Infusing items, see the [Infusion Rituals](category://crafting_rituals) Category.\n".formatted(COLOR_PURPLE));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withDescription(this.context().entryDescription()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(1, 1).withPages(new BookPageModel[]{intro, more});
    }
}

