/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import org.jetbrains.annotations.NotNull;

public class NaturePasteItem
extends Item {
    public NaturePasteItem(Item.Properties properties) {
        super(properties);
        this.craftingRemainingItem = this;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Block test2;
        CropBlock crop;
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockpos);
        Player player = context.getPlayer();
        Block block = blockState.getBlock();
        if (block instanceof CropBlock && !(crop = (CropBlock)block).isMaxAge(blockState)) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            level.levelEvent(1505, blockpos, 15);
            level.setBlock(blockpos, crop.getStateForAge(crop.getMaxAge()), 2);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.getBlock() instanceof StemBlock) {
            if ((Integer)blockState.getValue((Property)BlockStateProperties.AGE_7) < 7) {
                level.setBlock(blockpos, (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(7)), 2);
            } else if (!level.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int test2 = 0; test2 < 100; ++test2) {
                    blockState.randomTick(serverLevel, blockpos, RandomSource.create((long)test2));
                    if (!(level.getBlockState(blockpos).getBlock() instanceof AttachedStemBlock)) continue;
                    test2 += 100;
                }
            }
            level.levelEvent(1505, blockpos, 15);
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.getBlock() instanceof SweetBerryBushBlock) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            level.levelEvent(1505, blockpos, 15);
            level.setBlock(blockpos, (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)), 2);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.getBlock() instanceof MangrovePropaguleBlock) {
            if ((Integer)blockState.getValue((Property)BlockStateProperties.AGE_4) != 4) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
                level.levelEvent(1505, blockpos, 15);
                level.setBlockAndUpdate(blockpos, (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(4)));
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (((Boolean)blockState.getValue((Property)BlockStateProperties.HANGING)).booleanValue()) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if ((test2 = blockState.getBlock()) instanceof SaplingBlock) {
            SaplingBlock sapling = (SaplingBlock)test2;
            if (!level.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)level;
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
                BlockState blockState1 = (BlockState)blockState.setValue((Property)BlockStateProperties.STAGE, (Comparable)Integer.valueOf(1));
                sapling.advanceTree(serverLevel, blockpos, blockState1, RandomSource.create());
                level.levelEvent(1505, blockpos, 15);
                return InteractionResult.CONSUME;
            }
        }
        if (blockState.getBlock() instanceof FungusBlock || blockState.getBlock() instanceof MushroomBlock || blockState.getBlock() instanceof AzaleaBlock) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            level.levelEvent(1505, blockpos, 15);
            for (int test3 = 0; test3 < 100; ++test3) {
                if (NaturePasteItem.applyBonemeal(context.getItemInHand(), level, blockpos, player)) continue;
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (blockState.getBlock() instanceof NetherWartBlock && (Integer)blockState.getValue((Property)BlockStateProperties.AGE_3) != 3) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            level.levelEvent(1505, blockpos, 15);
            level.setBlockAndUpdate(blockpos, (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)));
            ParticleUtils.spawnParticleInBlock((LevelAccessor)level, (BlockPos)blockpos, (int)15, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.getBlock() instanceof VineBlock) {
            ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)blockpos, (int)45, (double)0.3, (double)1.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            level.levelEvent(1505, blockpos, 15);
            if (!level.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int test4 = 0; test4 < 100; ++test4) {
                    blockState.randomTick(serverLevel, blockpos, RandomSource.create((long)test4));
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (blockState.getBlock() instanceof SugarCaneBlock || blockState.getBlock() instanceof CactusBlock) {
            for (int i = 1; i < level.getMaxBuildHeight() - blockpos.getY(); ++i) {
                if (level.getBlockState(blockpos.above(i)).canBeReplaced()) {
                    level.setBlockAndUpdate(blockpos.above(i), blockState.getBlock().defaultBlockState());
                    ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)blockpos, (int)45, (double)0.6, (double)1.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
                    level.levelEvent(1505, blockpos, 15);
                    if (blockState.canSurvive((LevelReader)level, blockpos.above(i))) break;
                    level.destroyBlock(blockpos.above(i), true);
                    break;
                }
                if (!level.getBlockState(blockpos.above(i)).getBlock().equals(blockState.getBlock())) break;
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (NaturePasteItem.applyBonemeal(context.getItemInHand(), level, blockpos, player)) {
            if (!level.isClientSide) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos, 15);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockState blockstate = level.getBlockState(blockpos);
        boolean flag = blockstate.isFaceSturdy((BlockGetter)level, blockpos, context.getClickedFace());
        if (flag && NaturePasteItem.growWaterPlant(context.getItemInHand(), level, blockpos.relative(context.getClickedFace()), context.getClickedFace())) {
            if (!level.isClientSide) {
                player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos, 15);
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(context.getItemInHand()));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean applyBonemeal(ItemStack naturePaste, Level level, BlockPos blockPos, @Nullable Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = level.getBlockState(blockPos);
        BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)blockPos, (BlockState)blockstate, (ItemStack)naturePaste);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        Block block = blockstate.getBlock();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, blockPos, blockstate)) {
            if (level instanceof ServerLevel && bonemealableblock.isBonemealSuccess(level, level.random, blockPos, blockstate)) {
                bonemealableblock.performBonemeal((ServerLevel)level, level.random, blockPos, blockstate);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack stack, Level level, BlockPos pos, @Nullable Direction clickedSide) {
        if (level.getBlockState(pos).is(Blocks.WATER) && level.getFluidState(pos).getAmount() == 8 && !stack.isEmpty()) {
            ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)pos, (int)45, (double)3.0, (double)1.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
            if (level instanceof ServerLevel) {
                RandomSource randomsource = level.getRandom();
                block0: for (int i = 0; i < 128; ++i) {
                    BlockPos blockpos = pos;
                    BlockState blockstate = Blocks.SEAGRASS.defaultBlockState();
                    for (int j = 0; j < i / 16; ++j) {
                        if (level.getBlockState(blockpos = blockpos.offset(randomsource.nextInt(3) - 1, (randomsource.nextInt(3) - 1) * randomsource.nextInt(3) / 2, randomsource.nextInt(3) - 1)).isCollisionShapeFullBlock((BlockGetter)level, blockpos)) continue block0;
                    }
                    Holder holder = level.getBiome(blockpos);
                    if (holder.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                        if (i == 0 && clickedSide != null && clickedSide.getAxis().isHorizontal()) {
                            blockstate = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, level.random).map(p_204100_ -> ((Block)p_204100_.value()).defaultBlockState()).orElse(blockstate);
                            if (blockstate.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                                blockstate = (BlockState)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)clickedSide);
                            }
                        } else if (randomsource.nextInt(4) == 0) {
                            blockstate = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.UNDERWATER_BONEMEALS, level.random).map(p_204095_ -> ((Block)p_204095_.value()).defaultBlockState()).orElse(blockstate);
                        }
                    }
                    if (blockstate.is(BlockTags.WALL_CORALS, p_204093_ -> p_204093_.hasProperty((Property)BaseCoralWallFanBlock.FACING))) {
                        for (int k = 0; !blockstate.canSurvive((LevelReader)level, blockpos) && k < 4; ++k) {
                            blockstate = (BlockState)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(randomsource));
                        }
                    }
                    if (!blockstate.canSurvive((LevelReader)level, blockpos)) continue;
                    BlockState blockState1 = level.getBlockState(blockpos);
                    if (blockState1.is(Blocks.WATER) && level.getFluidState(blockpos).getAmount() == 8) {
                        level.setBlock(blockpos, blockstate, 3);
                        continue;
                    }
                    if (!blockState1.is(Blocks.SEAGRASS) || randomsource.nextInt(10) != 0) continue;
                    ((BonemealableBlock)Blocks.SEAGRASS).performBonemeal((ServerLevel)level, randomsource, blockpos, blockState1);
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack remain = itemStack.copy();
        remain.setDamageValue(itemStack.getDamageValue() + 1);
        return remain.getDamageValue() == remain.getMaxDamage() ? ItemStack.EMPTY : remain;
    }
}

